/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.crackshot;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.shampaggon.crackshot.events.WeaponDamageEntityEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CrackShotWeaponDamageEntityEvent
extends BukkitScriptEvent
implements Listener {
    public static CrackShotWeaponDamageEntityEvent instance;
    public WeaponDamageEntityEvent event;

    public CrackShotWeaponDamageEntityEvent() {
        instance = this;
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (!CrackShotWeaponDamageEntityEvent.isDefaultDetermination((ObjectTag)determinationObj)) {
            ElementTag newDamage = new ElementTag(determination);
            if (!newDamage.isDouble()) {
                Debug.echoError((String)"Determination for 'damage' must be a valid number.");
                return false;
            }
            this.event.setDamage(newDamage.asDouble());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("crackshot weapon damages entity");
    }

    public String getName() {
        return "CrackShotWeaponDamagesEntity";
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "headshot": {
                return new ElementTag(this.event.isHeadshot());
            }
            case "critical": {
                return new ElementTag(this.event.isCritical());
            }
            case "backstab": {
                return new ElementTag(this.event.isBackstab());
            }
            case "damage": {
                return new ElementTag(this.event.getDamage());
            }
            case "damager": {
                return this.getDamager();
            }
            case "victim": {
                return new EntityTag(this.event.getVictim());
            }
            case "weapon": {
                return new ElementTag(this.event.getWeaponTitle());
            }
        }
        return super.getContext(name);
    }

    public ObjectTag getDamager() {
        return this.event.getDamager() != null ? new EntityTag(this.event.getDamager()) : new PlayerTag(this.event.getPlayer());
    }

    @EventHandler
    public void onEntityDamaged(WeaponDamageEntityEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

