/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.crackshot;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.shampaggon.crackshot.events.WeaponAttachmentToggleEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CrackShotPlayerTogglesWeaponAttachmentEvent
extends BukkitScriptEvent
implements Listener {
    public static CrackShotPlayerTogglesWeaponAttachmentEvent instance;
    public WeaponAttachmentToggleEvent event;

    public CrackShotPlayerTogglesWeaponAttachmentEvent() {
        instance = this;
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase((String)determination);
        if (lower.startsWith("toggle_delay:")) {
            ElementTag newBulletSpread = new ElementTag(lower.substring("toggle_delay:".length()));
            if (!newBulletSpread.isInt()) {
                Debug.echoError((String)"Determination for 'toggle_delay' must be a valid integer.");
                return false;
            }
            this.event.setToggleDelay(newBulletSpread.asInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("crackshot player toggles weapon attachment");
    }

    public String getName() {
        return "CrackShotPlayerTogglesWeaponAttachment";
    }

    public ObjectTag getContext(String name) {
        if (name.equals("delay")) {
            return new DurationTag(this.event.getToggleDelay());
        }
        if (name.equals("weapon")) {
            return new ElementTag(this.event.getWeaponTitle());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onTogglesAttachment(WeaponAttachmentToggleEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

