/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.crackshot;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.shampaggon.crackshot.events.WeaponReloadEvent;
import java.util.Arrays;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CrackShotPlayerStartsReloadingWeaponEvent
extends BukkitScriptEvent
implements Listener {
    public static CrackShotPlayerStartsReloadingWeaponEvent instance;
    public WeaponReloadEvent event;

    public CrackShotPlayerStartsReloadingWeaponEvent() {
        instance = this;
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (!CrackShotPlayerStartsReloadingWeaponEvent.isDefaultDetermination((ObjectTag)determinationObj)) {
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase((String)determination);
            if (lower.startsWith("reload_speed:")) {
                ElementTag newReloadSpeed = new ElementTag(lower.substring("reload_speed:".length()));
                if (!newReloadSpeed.isDouble()) {
                    Debug.echoError((String)"Determination for 'reload_speed' must be a valid number.");
                    return false;
                }
                this.event.setReloadSpeed(newReloadSpeed.asDouble());
                return true;
            }
            if (lower.startsWith("reload_time:")) {
                String time = lower.substring("reload_time:".length());
                if (!DurationTag.matches((String)time)) {
                    Debug.echoError((String)"Determination for 'reload_time' must be a valid DurationTag.");
                    return false;
                }
                DurationTag newReloadtime = DurationTag.valueOf((String)lower.substring("reload_time:".length()), (TagContext)this.getTagContext(path));
                this.event.setReloadDuration(newReloadtime.getTicksAsInt());
                return true;
            }
            if (lower.startsWith("reload_sounds:")) {
                String newReloadSounds = determination.substring("reload_sounds:".length());
                if (CoreUtilities.equalsIgnoreCase((String)newReloadSounds, (String)"none")) {
                    newReloadSounds = "";
                }
                this.event.setSounds(newReloadSounds);
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("crackshot player starts reloading weapon");
    }

    public String getName() {
        return "CrackShotPlayerStartsReloadingWeapon";
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "weapon": {
                return new ElementTag(this.event.getWeaponTitle());
            }
            case "reload_speed": {
                return new ElementTag(this.event.getReloadSpeed());
            }
            case "reload_time": {
                return new ElementTag(this.event.getReloadDuration());
            }
            case "reload_sounds": {
                return new ListTag(Arrays.asList(this.event.getSounds().split(",")));
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onStartsReloading(WeaponReloadEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

