/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.bungee;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import java.util.List;

public class BungeeProxyServerListPingScriptEvent
extends BukkitScriptEvent {
    public static BungeeProxyServerListPingScriptEvent instance;
    public PingData data;

    public BungeeProxyServerListPingScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("proxy server list ping");
    }

    public void init() {
        BungeeBridge.instance.controlsProxyPing = true;
        BungeeBridge.instance.checkBroadcastProxyPing();
    }

    public void destroy() {
        BungeeBridge.instance.controlsProxyPing = false;
        BungeeBridge.instance.checkBroadcastProxyPing();
    }

    public String getName() {
        return "BungeeProxyServerListPing";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String determinationLow = CoreUtilities.toLowerCase((String)determination);
            if (determinationLow.startsWith("max_players:")) {
                this.data.maxPlayers = Integer.parseInt(determination.substring("max_players:".length()));
                return true;
            }
            if (determinationLow.startsWith("version:")) {
                this.data.version = determination.substring("version:".length());
                return true;
            }
            if (determinationLow.startsWith("motd:")) {
                this.data.motd = determination.substring("motd:".length());
                return true;
            }
            if (determinationLow.startsWith("players:")) {
                this.data.playerSample = ListTag.valueOf((String)determination.substring("players:".length()), (TagContext)this.getTagContext(path)).filter(PlayerTag.class, (TagContext)this.getTagContext(path));
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "address": {
                return new ElementTag(this.data.address);
            }
            case "num_players": 
            case "current_players": {
                return new ElementTag(this.data.currentPlayers);
            }
            case "max_players": {
                return new ElementTag(this.data.maxPlayers);
            }
            case "motd": {
                return new ElementTag(this.data.motd);
            }
            case "protocol": {
                return new ElementTag(this.data.protocol);
            }
            case "version": {
                return new ElementTag(this.data.version);
            }
        }
        return super.getContext(name);
    }

    public static class PingData {
        public String address;
        public int currentPlayers;
        public int maxPlayers;
        public String motd;
        public int protocol;
        public String version;
        public List<PlayerTag> playerSample;
    }
}

