/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.bungee;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class BungeePlayerServerSwitchScriptEvent
extends BukkitScriptEvent {
    public static BungeePlayerServerSwitchScriptEvent instance;
    public String name;
    public UUID uuid;
    public String newServer;

    public BungeePlayerServerSwitchScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("bungee player switches to");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String serverName = path.eventArgLowerAt(4);
        if (!serverName.equals("server") && !serverName.equalsIgnoreCase(this.newServer)) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "BungeePlayerServerSwitch";
    }

    public ScriptEntryData getScriptEntryData() {
        OfflinePlayer player = null;
        try {
            player = Bukkit.getOfflinePlayer((UUID)this.uuid);
            if (!player.hasPlayedBefore()) {
                player = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new BukkitScriptEntryData(player == null ? null : new PlayerTag(player), null);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "name": {
                return new ElementTag(this.name);
            }
            case "uuid": {
                return new ElementTag(this.uuid.toString());
            }
            case "server": {
                return new ElementTag(this.newServer);
            }
        }
        return super.getContext(name);
    }
}

