/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.quests;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bridges.QuestsBridge;
import me.blackvein.quests.Quest;
import me.blackvein.quests.Quester;
import me.blackvein.quests.Quests;
import me.blackvein.quests.util.Lang;
import org.bukkit.entity.Player;

public class QuestsCommand
extends AbstractCommand {
    public QuestsCommand() {
        this.setName("quests");
        this.setSyntax("quests [add/remove/set] (quest:<quest_id>) (stage:<#>) (points:<#>) (override_checks:{true}/false)");
        this.setRequiredArguments(2, 5);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum((Enum[])Action.values())) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("quest") && arg.matchesPrefix("quest")) {
                scriptEntry.addObject("quest", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("stage") && arg.matchesPrefix("stage") && arg.matchesInteger()) {
                scriptEntry.addObject("stage", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("points") && arg.matchesPrefix("points") && arg.matchesInteger()) {
                scriptEntry.addObject("points", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("override_checks") && arg.matchesPrefix("override_checks") && arg.matchesBoolean()) {
                scriptEntry.addObject("override_checks", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
            throw new InvalidArgumentsException("Must have a linked player!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid action!");
        }
        scriptEntry.defaultObject("override_checks", new Object[]{new ElementTag("true")});
    }

    public void execute(ScriptEntry scriptEntry) {
        Quests quests = (Quests)QuestsBridge.instance.plugin;
        ElementTag action = scriptEntry.getElement("action");
        ElementTag questId = scriptEntry.getElement("quest");
        ElementTag stageNum = scriptEntry.getElement("stage");
        ElementTag points = scriptEntry.getElement("points");
        ElementTag override_checks = scriptEntry.getElement("override_checks");
        PlayerTag player = Utilities.getEntryPlayer((ScriptEntry)scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)(action.debug() + (questId != null ? questId.debug() : "") + (stageNum != null ? stageNum.debug() : "") + (points != null ? points.debug() : "") + override_checks.debug()));
        }
        block1 : switch (Action.valueOf(action.asString().toUpperCase())) {
            case ADD: {
                if (questId != null) {
                    for (Quest quest : quests.getQuests()) {
                        if (!quest.getId().equals(questId.asString())) continue;
                        quests.getQuester(player.getPlayerEntity().getUniqueId()).takeQuest(quest, override_checks.asBoolean());
                        break block1;
                    }
                    break;
                }
                if (points != null && points.asInt() > 0) {
                    Quester quester = quests.getQuester(player.getPlayerEntity().getUniqueId());
                    quester.setQuestPoints(quester.getQuestPoints() + points.asInt());
                    this.reloadData(quester);
                    break;
                }
                Debug.echoError((String)"Must specify either a quest or a points value.");
                break;
            }
            case REMOVE: {
                if (questId != null) {
                    for (Quest quest : quests.getQuests()) {
                        if (!quest.getId().equals(questId.asString())) continue;
                        Quester quester = quests.getQuester(player.getPlayerEntity().getUniqueId());
                        quester.hardQuit(quest);
                        if (override_checks.asBoolean() && player.isOnline()) {
                            player.getPlayerEntity().sendMessage(Lang.get((Player)player.getPlayerEntity(), (String)"questQuit").replace("<quest>", quest.getName()));
                        }
                        this.reloadData(quester);
                        quester.updateJournal();
                        break block1;
                    }
                    break;
                }
                if (points != null && points.asInt() > 0) {
                    Quester quester;
                    int n = (quester = quests.getQuester(player.getPlayerEntity().getUniqueId())).getQuestPoints() - points.asInt();
                    quester.setQuestPoints(n <= 0 ? 0 : n);
                    this.reloadData(quester);
                    break;
                }
                Debug.echoError((String)"Must specify either a quest value or a points value.");
                break;
            }
            case SET: {
                if (questId != null && stageNum != null && stageNum.asInt() > 0) {
                    for (Quest quest : quests.getQuests()) {
                        if (!quest.getId().equals(questId.asString())) continue;
                        try {
                            quest.setStage(quests.getQuester(player.getPlayerEntity().getUniqueId()), stageNum.asInt());
                        }
                        catch (IndexOutOfBoundsException ex) {
                            Debug.echoError((Throwable)ex);
                        }
                        break block1;
                    }
                    break;
                }
                if (points != null && points.asInt() >= 0) {
                    Quester quester = quests.getQuester(player.getPlayerEntity().getUniqueId());
                    quester.setQuestPoints(points.asInt());
                    this.reloadData(quester);
                    break;
                }
                Debug.echoError((String)"Must specify either a quest and stage value, or a points value.");
            }
        }
    }

    private void reloadData(Quester quester) {
        if (quester == null) {
            return;
        }
        quester.saveData();
        quester.loadData();
    }

    private static enum Action {
        ADD,
        REMOVE,
        SET;

    }
}

