/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.noteblockapi;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.xxmicloxx.NoteBlockAPI.NoteBlockAPI;
import com.xxmicloxx.NoteBlockAPI.model.Song;
import com.xxmicloxx.NoteBlockAPI.songplayer.RadioSongPlayer;
import com.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import java.io.File;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;

public class NBSCommand
extends AbstractCommand {
    public NBSCommand() {
        this.setName("nbs");
        this.setSyntax("nbs [play/stop] (file:<file path>) (targets:<entity>|...)");
        this.setRequiredArguments(1, 3);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix(new String[]{"targets", "targets"}) && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("targets", (Object)((ListTag)arg.asType(ListTag.class)).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("file") && arg.matchesPrefix("file")) {
                scriptEntry.addObject("file", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesEnum((Enum[])Action.values())) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Action not specified! (play/stop)");
        }
        if (!scriptEntry.hasObject("targets")) {
            if (Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
                scriptEntry.addObject("targets", Collections.singletonList(Utilities.getEntryPlayer((ScriptEntry)scriptEntry)));
            } else {
                throw new InvalidArgumentsException("Must specify players to add, remove or spectate!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        ElementTag file = (ElementTag)scriptEntry.getObjectTag("file");
        ElementTag action = (ElementTag)scriptEntry.getObjectTag("action");
        List targets = (List)scriptEntry.getObject("targets");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)(action.debug() + ArgumentHelper.debugList((String)"targets", (Collection)targets) + (file != null ? file.debug() : "")));
        }
        if (targets == null || targets.isEmpty()) {
            Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Targets not found!");
            return;
        }
        if (action.asString().equalsIgnoreCase("play")) {
            if (file == null) {
                Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"File not specified!");
                return;
            }
            String directory = URLDecoder.decode(System.getProperty("user.dir"));
            Song s = NBSDecoder.parse((File)new File(directory + "/plugins/Denizen/" + file + ".nbs"));
            RadioSongPlayer sp = new RadioSongPlayer(s);
            sp.setAutoDestroy(true);
            for (PlayerTag p : targets) {
                sp.addPlayer(p.getPlayerEntity());
            }
            sp.setPlaying(true);
        } else if (action.asString().equalsIgnoreCase("stop")) {
            for (PlayerTag p : targets) {
                NoteBlockAPI.stopPlaying((Player)p.getPlayerEntity());
            }
        }
    }

    private static enum Action {
        PLAY,
        STOP;

    }
}

