/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.mythicmobs;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.objects.mythicmobs.MythicMobsMobTag;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Entity;

public class MythicSignalCommand
extends AbstractCommand {
    public MythicSignalCommand() {
        this.setName("mythicsignal");
        this.setSyntax("mythicsignal [<mythicmob>|...] [<signal>] [source:<entity>]");
        this.setRequiredArguments(3, 3);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(MythicMobsMobTag.class)) {
                scriptEntry.addObject("targets", (Object)((ListTag)arg.asType(ListTag.class)).filter(MythicMobsMobTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("source") && arg.matchesPrefix("source") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("source", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("signal")) {
                scriptEntry.addObject("signal", (Object)arg.asType(ElementTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targets")) {
            throw new InvalidArgumentsException("Must specify MythicMobs to send the signal to.");
        }
        if (!scriptEntry.hasObject("signal")) {
            throw new InvalidArgumentsException("Must specify a signal to send.");
        }
        if (!scriptEntry.hasObject("source")) {
            throw new InvalidArgumentsException("Must specify a source entity.");
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        EntityTag source = (EntityTag)scriptEntry.getObjectTag("source");
        List targets = (List)scriptEntry.getObject("targets");
        ElementTag signal = scriptEntry.getElement("signal");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)(ArgumentHelper.debugList((String)"mythicmobs", (Collection)targets) + signal.debug() + source.debug()));
        }
        for (MythicMobsMobTag mob : targets) {
            mob.getMob().signalMob(BukkitAdapter.adapt((Entity)source.getBukkitEntity()), signal.asString());
        }
    }
}

