/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.mobarena;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.objects.mobarena.MobArenaArenaTag;
import com.garbagemule.MobArena.framework.Arena;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;

public class MobArenaCommand
extends AbstractCommand {
    public MobArenaCommand() {
        this.setName("mobarena");
        this.setSyntax("mobarena [<mobarena>] (add:<player>|...) (remove:<player>|...) (spectate:<player>|...)");
        this.setRequiredArguments(1, 4);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("arena") && (arg.matchesPrefix("arena") || MobArenaArenaTag.matches(arg.getValue()))) {
                scriptEntry.addObject("arena", (Object)MobArenaArenaTag.valueOf(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("add") && arg.matchesPrefix(new String[]{"add", "join"}) && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("add", (Object)((ListTag)arg.asType(ListTag.class)).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("remove") && arg.matchesPrefix(new String[]{"remove", "leave"}) && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("remove", (Object)((ListTag)arg.asType(ListTag.class)).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("spectate") && arg.matchesPrefix(new String[]{"spectate", "spec"}) && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("spectate", (Object)((ListTag)arg.asType(ListTag.class)).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("arena")) {
            throw new InvalidArgumentsException("Must specify a valid MobArena!");
        }
        if (!(scriptEntry.hasObject("add") || scriptEntry.hasObject("remove") || scriptEntry.hasObject("spectate"))) {
            throw new InvalidArgumentsException("Must specify players to add, remove or spectate!");
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        MobArenaArenaTag arena = (MobArenaArenaTag)scriptEntry.getObjectTag("arena");
        List add = (List)scriptEntry.getObject("add");
        List remove = (List)scriptEntry.getObject("remove");
        List spectate = (List)scriptEntry.getObject("spectate");
        Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)(arena.debug() + ArgumentHelper.debugList((String)"Add Players", (Collection)add) + ArgumentHelper.debugList((String)"Remove Players", (Collection)remove) + ArgumentHelper.debugList((String)"Spectate Players", (Collection)spectate)));
        Arena mobArena = arena.getArena();
        if (add != null && !add.isEmpty()) {
            for (PlayerTag p : add) {
                if (!mobArena.canJoin(p.getPlayerEntity())) continue;
                mobArena.playerJoin(p.getPlayerEntity(), (Location)p.getLocation());
            }
        }
        if (remove != null && !remove.isEmpty()) {
            for (PlayerTag p : remove) {
                if (!mobArena.getAllPlayers().contains(p.getPlayerEntity())) continue;
                mobArena.playerLeave(p.getPlayerEntity());
            }
        }
        if (spectate != null && !spectate.isEmpty()) {
            for (PlayerTag p : spectate) {
                if (!mobArena.canSpec(p.getPlayerEntity())) continue;
                mobArena.playerSpec(p.getPlayerEntity(), (Location)p.getLocation());
            }
        }
    }
}

