/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.libsdisguises;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class LibsDisguiseCommand
extends AbstractCommand {
    public LibsDisguiseCommand() {
        this.setName("libsdisguise");
        this.setSyntax("libsdisguise [remove/player/mob/misc] (type:<entity type>) (target:<entity>) (name:<text>) (baby:true/{false}) (id:<item>) (self:true/{false})");
        this.setRequiredArguments(1, 6);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("target") && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("name") && arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesPrefix("type")) {
                scriptEntry.addObject("type", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("baby") && arg.matchesPrefix("baby")) {
                scriptEntry.addObject("baby", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("self") && arg.matchesPrefix("self")) {
                scriptEntry.addObject("self", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesEnum((Enum[])Action.values())) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Action not specified! (remove/mob/player/misc)");
        }
        if (!scriptEntry.hasObject("baby")) {
            scriptEntry.addObject("baby", (Object)new ElementTag(false));
        }
        if (!scriptEntry.hasObject("self")) {
            scriptEntry.addObject("self", (Object)new ElementTag(false));
        }
        if (!scriptEntry.hasObject("target")) {
            if (Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
                scriptEntry.addObject("target", (Object)Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getDenizenEntity());
            } else {
                throw new InvalidArgumentsException("This command does not have a player attached!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("target");
        ElementTag type = (ElementTag)scriptEntry.getObjectTag("type");
        ElementTag name = (ElementTag)scriptEntry.getObjectTag("name");
        ElementTag action = (ElementTag)scriptEntry.getObjectTag("action");
        ElementTag id = (ElementTag)scriptEntry.getObjectTag("id");
        ElementTag baby = (ElementTag)scriptEntry.getObjectTag("baby");
        ElementTag self = (ElementTag)scriptEntry.getObjectTag("self");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)(action.debug() + (target != null ? target.debug() : "") + (type != null ? type.debug() : "") + (name != null ? name.debug() : "") + (id != null ? id.debug() : "") + (baby != null ? baby.debug() : "")));
        }
        if (target == null) {
            Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Target not found!");
            return;
        }
        if (baby == null) {
            Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Baby not specified!");
            return;
        }
        if (action.asString().equalsIgnoreCase("remove")) {
            DisguiseAPI.undisguiseToAll((Entity)target.getBukkitEntity());
        } else if (action.asString().equalsIgnoreCase("mob")) {
            if (type == null) {
                Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Entity not specified!");
                return;
            }
            MobDisguise mobDisguise = new MobDisguise(DisguiseType.valueOf((String)type.toString().toUpperCase()), !baby.asBoolean());
            LivingWatcher watcher = mobDisguise.getWatcher();
            if (name != null) {
                watcher.setCustomNameVisible(true);
                watcher.setCustomName(name.toString());
            }
            if (target.isPlayer() && self.asBoolean()) {
                DisguiseAPI.disguiseIgnorePlayers((Entity)target.getBukkitEntity(), (Disguise)mobDisguise, (Player[])new Player[]{target.getPlayer()});
            } else {
                DisguiseAPI.disguiseToAll((Entity)target.getBukkitEntity(), (Disguise)mobDisguise);
            }
        } else if (action.asString().equalsIgnoreCase("player")) {
            if (name == null) {
                Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Name not specified!");
                return;
            }
            PlayerDisguise playerDisguise = new PlayerDisguise(name.toString());
            if (target.isPlayer() && self.asBoolean()) {
                DisguiseAPI.disguiseIgnorePlayers((Entity)target.getBukkitEntity(), (Disguise)playerDisguise, (Player[])new Player[]{target.getPlayer()});
            } else {
                DisguiseAPI.disguiseToAll((Entity)target.getBukkitEntity(), (Disguise)playerDisguise);
            }
        } else if (action.asString().equalsIgnoreCase("misc")) {
            MiscDisguise miscDisguise;
            if (type == null) {
                Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Entity not specified!");
                return;
            }
            DisguiseType disType = DisguiseType.valueOf((String)type.toString().toUpperCase());
            if (disType == DisguiseType.FALLING_BLOCK || disType == DisguiseType.DROPPED_ITEM) {
                if (id == null) {
                    Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"ID not specified!");
                    return;
                }
                miscDisguise = new MiscDisguise(disType, ItemTag.valueOf((String)id.asString(), (TagContext)scriptEntry.context).getItemStack());
            } else {
                miscDisguise = new MiscDisguise(disType);
            }
            FlagWatcher watcher = miscDisguise.getWatcher();
            if (name != null) {
                watcher.setCustomNameVisible(true);
                watcher.setCustomName(name.toString());
            }
            if (target.isPlayer() && self.asBoolean()) {
                DisguiseAPI.disguiseIgnorePlayers((Entity)target.getBukkitEntity(), (Disguise)miscDisguise, (Player[])new Player[]{target.getPlayer()});
            } else {
                DisguiseAPI.disguiseToAll((Entity)target.getBukkitEntity(), (Disguise)miscDisguise);
            }
        }
    }

    private static enum Action {
        REMOVE,
        MOB,
        PLAYER,
        MISC;

    }
}

