/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.jobs;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.depenizen.bukkit.objects.jobs.JobsJobTag;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.JobsPlayer;

public class JobsCommand
extends AbstractCommand {
    public JobsCommand() {
        this.setName("jobs");
        this.setSyntax("jobs [promote/demote/join/quit] [<job>] (<#>)");
        this.setRequiredArguments(2, 3);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum((Enum[])Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("job") && arg.matchesArgumentType(JobsJobTag.class)) {
                scriptEntry.addObject("job", (Object)JobsJobTag.valueOf(arg.getValue()));
                continue;
            }
            if (scriptEntry.hasObject("number") || !arg.matchesInteger()) continue;
            scriptEntry.addObject("number", (Object)new ElementTag(arg.getValue()));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if (!scriptEntry.hasObject("job")) {
            throw new InvalidArgumentsException("Must specify a job!");
        }
        if (!Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
            throw new InvalidArgumentsException("Must have a player attached to the queue.");
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        JobsJobTag job = (JobsJobTag)scriptEntry.getObjectTag("job");
        int number = scriptEntry.hasObject("number") ? scriptEntry.getElement("number").asInt() : 0;
        JobsPlayer player = Jobs.getPlayerManager().getJobsPlayer(Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getName());
        switch (action) {
            case PROMOTE: {
                player.promoteJob(job.getJob(), number);
                break;
            }
            case DEMOTE: {
                player.demoteJob(job.getJob(), number);
                break;
            }
            case JOIN: {
                player.joinJob(job.getJob());
                break;
            }
            case QUIT: {
                player.leaveJob(job.getJob());
            }
        }
    }

    private static enum Action {
        PROMOTE,
        DEMOTE,
        JOIN,
        QUIT;

    }
}

