/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.effectlib;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bridges.EffectLibBridge;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.effect.ArcEffect;
import de.slikey.effectlib.effect.AtomEffect;
import de.slikey.effectlib.effect.BleedEffect;
import org.bukkit.Location;

public class EffectLibCommand
extends AbstractCommand {
    public EffectLibCommand() {
        this.setName("effectlib");
        this.setSyntax("effectlib (type:<effect name>) (duration:<duration>) (target:<entity>/location:<location>)");
        this.setRequiredArguments(1, 3);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("target") && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration")) {
                scriptEntry.addObject("duration", (Object)arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesPrefix("location")) {
                scriptEntry.addObject("location", (Object)arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesEnum((Enum[])Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Effect not specified!");
        }
        if (!scriptEntry.hasObject("duration")) {
            throw new InvalidArgumentsException("Duration not specified!");
        }
        if (!scriptEntry.hasObject("target") && Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
            scriptEntry.addObject("target", (Object)Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getDenizenEntity());
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("target");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)((target != null ? target.debug() : "") + (action != null ? action.toString() : "") + (duration != null ? duration.debug() : "") + (location != null ? location.debug() : "")));
        }
        if (target == null && location == null) {
            Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Target not found!");
            return;
        }
        if (action == null) {
            Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Effect type not specified!");
            return;
        }
        if (duration == null) {
            Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Duration not specified!");
            return;
        }
        int ticks = duration.getTicksAsInt();
        EffectManager effectManager = new EffectManager(EffectLibBridge.instance.plugin);
        switch (action) {
            case BLEED: {
                BleedEffect effect = new BleedEffect(effectManager);
                if (location == null) {
                    effect.setEntity(target.getBukkitEntity());
                } else {
                    effect.setLocation(new Location(location.getWorld(), location.getX(), location.getY(), location.getZ()));
                }
                effect.callback = () -> scriptEntry.setFinished(true);
                effect.iterations = ticks;
                effect.start();
                return;
            }
            case ARC: {
                ArcEffect effect = new ArcEffect(effectManager);
                if (location == null) {
                    effect.setEntity(target.getBukkitEntity());
                } else {
                    effect.setLocation(new Location(location.getWorld(), location.getX(), location.getY(), location.getZ()));
                }
                effect.callback = () -> scriptEntry.setFinished(true);
                effect.iterations = ticks;
                effect.start();
                return;
            }
            case ATOM: {
                AtomEffect effect = new AtomEffect(effectManager);
                if (location == null) {
                    effect.setEntity(target.getBukkitEntity());
                } else {
                    effect.setLocation(new Location(location.getWorld(), location.getX(), location.getY(), location.getZ()));
                }
                effect.callback = () -> scriptEntry.setFinished(true);
                effect.iterations = ticks;
                effect.start();
                return;
            }
        }
        Debug.echoError((ScriptQueue)scriptEntry.getResidingQueue(), (String)"Effect type not found!");
    }

    private static enum Action {
        BLEED,
        ARC,
        ATOM;

    }
}

