/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.bungee;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.KeepAlivePacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.RedirectPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.redirectable.ReadTagPacketOut;
import com.denizenscript.depenizen.bukkit.commands.bungee.BungeeCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BungeeTagCommand
extends AbstractCommand
implements Holdable {
    public static Map<Integer, ScriptEntry> waitingEntries = new HashMap<Integer, ScriptEntry>();
    public static int currentId = 1;

    public BungeeTagCommand() {
        this.setName("bungeetag");
        this.setSyntax("bungeetag [server:<server>] [<tags>]");
        this.setRequiredArguments(2, 2);
        this.setParseArgs(false);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (String arg : scriptEntry.getArguments()) {
            if (!scriptEntry.hasObject("server") && arg.startsWith("server:")) {
                scriptEntry.addObject("server", (Object)new ElementTag(TagManager.tag((String)arg.substring("server:".length()), (TagContext)scriptEntry.entryData.getTagContext())));
                continue;
            }
            if (!scriptEntry.hasObject("tag")) {
                scriptEntry.addObject("tag", (Object)new ElementTag(arg));
                continue;
            }
            Debug.echoError((String)('\'' + arg + "' is an unknown argument!"));
        }
        if (!scriptEntry.hasObject("tag")) {
            throw new InvalidArgumentsException("Must define a TAG to be read.");
        }
        if (!scriptEntry.hasObject("server")) {
            throw new InvalidArgumentsException("Must define a server to run the tag on.");
        }
        if (!scriptEntry.shouldWaitFor()) {
            throw new InvalidArgumentsException("The BungeeTag command must be ~waited for!");
        }
    }

    public static void handleResult(int id, String result) {
        ScriptEntry entry = waitingEntries.remove(id);
        if (entry == null) {
            return;
        }
        entry.addObject("result", (Object)new ElementTag(result));
        entry.setFinished(true);
    }

    public void execute(ScriptEntry scriptEntry) {
        ElementTag tag = scriptEntry.getElement("tag");
        ElementTag server = scriptEntry.getElement("server");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)(tag.debug() + server.debug()));
        }
        if (!BungeeBridge.instance.connected) {
            Debug.echoError((String)"Cannot BungeeTag: bungee is not connected!");
            scriptEntry.setFinished(true);
            return;
        }
        int newId = currentId++;
        StringBuilder defNames = new StringBuilder();
        StringBuilder defValues = new StringBuilder();
        for (Map.Entry def : scriptEntry.getResidingQueue().getAllDefinitions().map.entrySet()) {
            defNames.append(BungeeCommand.escape(((StringHolder)def.getKey()).low)).append("\n");
            defValues.append(BungeeCommand.escape(((ObjectTag)def.getValue()).toString())).append("\n");
        }
        ReadTagPacketOut packetTag = new ReadTagPacketOut();
        packetTag.playerUUID = Utilities.entryHasPlayer((ScriptEntry)scriptEntry) ? Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getUUID() : new UUID(0L, 0L);
        packetTag.tag = tag.asString();
        packetTag.id = newId;
        packetTag.defs = defNames.toString() + "\r" + defValues.toString();
        RedirectPacketOut packet = new RedirectPacketOut(server.asString(), packetTag);
        BungeeBridge.instance.sendPacket(packet);
        BungeeBridge.instance.sendPacket(new KeepAlivePacketOut());
        waitingEntries.put(newId, scriptEntry);
    }
}

