/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.bungee;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.KeepAlivePacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.RedirectPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.redirectable.RunScriptPacketOut;
import java.util.UUID;

public class BungeeRunCommand
extends AbstractCommand {
    public BungeeRunCommand() {
        this.setName("bungeerun");
        this.setSyntax("bungeerun [<server>|...] [<script name>] (def:<definition>|...)");
        this.setRequiredArguments(2, 3);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("def") && arg.matchesPrefix("def")) {
                scriptEntry.addObject("def", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("servers")) {
                scriptEntry.addObject("servers", (Object)arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("script_name")) {
                scriptEntry.addObject("script_name", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script_name")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
        if (!scriptEntry.hasObject("servers")) {
            throw new InvalidArgumentsException("Must define servers to run the script on.");
        }
        scriptEntry.defaultObject("def", new Object[]{new ElementTag("")});
    }

    public void execute(ScriptEntry scriptEntry) {
        ElementTag def = scriptEntry.getElement("def");
        ListTag servers = (ListTag)scriptEntry.getObjectTag("servers");
        ElementTag scriptName = scriptEntry.getElement("script_name");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)(def.debug() + servers.debug() + scriptName.debug()));
        }
        if (!BungeeBridge.instance.connected) {
            Debug.echoError((String)"Cannot BungeeRun: bungee is not connected!");
            return;
        }
        RunScriptPacketOut packetScript = new RunScriptPacketOut();
        packetScript.playerUUID = Utilities.entryHasPlayer((ScriptEntry)scriptEntry) ? Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getUUID() : new UUID(0L, 0L);
        packetScript.scriptName = scriptName.asString();
        packetScript.defs = def.asString();
        for (String server : servers) {
            RedirectPacketOut packet = new RedirectPacketOut(server, packetScript);
            BungeeBridge.instance.sendPacket(packet);
            BungeeBridge.instance.sendPacket(new KeepAlivePacketOut());
        }
    }
}

