/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.bungee;

import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ExecuteCommandPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.KeepAlivePacketOut;

public class BungeeExecuteCommand
extends AbstractCommand {
    public BungeeExecuteCommand() {
        this.setName("bungeeexecute");
        this.setSyntax("bungeeexecute [<command>]");
        this.setRequiredArguments(1, 1);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("command")) {
                scriptEntry.addObject("command", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("command")) {
            throw new InvalidArgumentsException("Must define a COMMAND to be run.");
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        ElementTag command = scriptEntry.getElement("command");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (String)command.debug());
        }
        if (!BungeeBridge.instance.connected) {
            Debug.echoError((String)"Cannot BungeeExecute: bungee is not connected!");
            return;
        }
        ExecuteCommandPacketOut packet = new ExecuteCommandPacketOut(command.asString());
        BungeeBridge.instance.sendPacket(packet);
        BungeeBridge.instance.sendPacket(new KeepAlivePacketOut());
    }
}

