/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee.packets.in;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.PacketIn;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class RunScriptPacketIn
extends PacketIn {
    @Override
    public String getName() {
        return "RunScript";
    }

    @Override
    public void process(ByteBuf data) {
        if (data.readableBytes() < 24) {
            BungeeBridge.instance.handler.fail("Invalid RunScriptPacket (bytes available: " + data.readableBytes() + ")");
            return;
        }
        int nameLength = data.readInt();
        if (data.readableBytes() < nameLength || nameLength < 0) {
            BungeeBridge.instance.handler.fail("Invalid RunScriptPacket (name bytes requested: " + nameLength + ")");
            return;
        }
        String scriptName = this.readString(data, nameLength);
        int defsLength = data.readInt();
        if (data.readableBytes() < defsLength || defsLength < 0) {
            BungeeBridge.instance.handler.fail("Invalid RunScriptPacket (def bytes requested: " + defsLength + ")");
            return;
        }
        String defs = this.readString(data, defsLength);
        long uuidMost = data.readLong();
        long uuidLeast = data.readLong();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            ScriptTag script;
            PlayerTag linkedPlayer = null;
            if (uuidMost != 0L || uuidLeast != 0L) {
                UUID uuid = new UUID(uuidMost, uuidLeast);
                try {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (player != null) {
                        linkedPlayer = new PlayerTag(player);
                    }
                }
                catch (Exception player) {
                    // empty catch block
                }
            }
            if ((script = ScriptTag.valueOf((String)scriptName, (TagContext)CoreUtilities.basicContext)) == null) {
                Debug.echoError((String)("Invalid Depenizen bungeerun script '" + scriptName + "': script does not exist."));
                return;
            }
            List entries = script.getContainer().getBaseEntries((ScriptEntryData)new BukkitScriptEntryData(linkedPlayer, null));
            if (entries.isEmpty()) {
                return;
            }
            ScriptQueue queue = new InstantQueue("BUNGEERUN_" + scriptName).addEntries(entries);
            int x = 1;
            BukkitTagContext context = new BukkitTagContext(linkedPlayer, null, script);
            ListTag definitions = ListTag.valueOf((String)defs, (TagContext)context);
            String[] definition_names = null;
            try {
                String str = script.getContainer().getString("definitions");
                if (str != null) {
                    definition_names = str.split("\\|");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String definition : definitions) {
                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                queue.addDefinition(name, definition);
                Debug.echoDebug((Debuggable)((Debuggable)entries.get(0)), (String)("Adding definition '" + name + "' as " + definition));
                ++x;
            }
            queue.addDefinition("raw_context", defs);
            queue.start();
        });
    }
}

