/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee.packets.in;

import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.PacketIn;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeeServerDisconnectScriptEvent;
import io.netty.buffer.ByteBuf;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class RemoveServerPacketIn
extends PacketIn {
    @Override
    public String getName() {
        return "RemoveServer";
    }

    @Override
    public void process(ByteBuf data) {
        if (data.readableBytes() < 4) {
            BungeeBridge.instance.handler.fail("Invalid RemoveServerPacket (bytes available: " + data.readableBytes() + ")");
            return;
        }
        int serverNameLength = data.readInt();
        if (data.readableBytes() < serverNameLength || serverNameLength < 0) {
            BungeeBridge.instance.handler.fail("Invalid RemoveServerPacket (name bytes requested: " + serverNameLength + ")");
            return;
        }
        String serverName = this.readString(data, serverNameLength);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            BungeeBridge.instance.knownServers.remove(serverName);
            BungeeServerDisconnectScriptEvent.instance.serverName = serverName;
            BungeeServerDisconnectScriptEvent.instance.fire();
        });
    }
}

