/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee;

import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.PacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ControlsProxyCommandPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ControlsProxyPingPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.MyInfoPacketOut;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BungeeClientHandler
extends ChannelInboundHandlerAdapter {
    public static final byte[] FAKE_HANDSHAKE = new byte[]{13, 0, 20, 7, 68, 0, 100, 101, 112, 101, 110, 80, 0, 1};
    public ByteBuf packetBuffer;
    public Channel channel;
    public int waitingLength;
    public int packetId;
    public Stage currentStage = Stage.AWAIT_HEADER;

    public void fail(String reason) {
        Debug.echoError((String)("Depenizen-Bungee connection failed: " + reason));
        this.channel.close();
        BungeeBridge.instance.connected = false;
    }

    public void reallocateBuf(ChannelHandlerContext ctx) {
        ByteBuf newBuf = ctx.alloc().buffer(32);
        if (this.packetBuffer != null) {
            newBuf.writeBytes(this.packetBuffer);
            this.packetBuffer.release();
        }
        this.packetBuffer = newBuf;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.packetBuffer != null) {
            this.packetBuffer.release();
        }
        this.packetBuffer = ctx.alloc().buffer(32);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        Debug.log((String)"Depenizen-Bungee connection ended.");
        this.packetBuffer.release();
        this.packetBuffer = null;
        BungeeBridge.instance.connected = false;
        BungeeBridge.instance.reconnect();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ByteBuf handshake = ctx.alloc().buffer(FAKE_HANDSHAKE.length);
        handshake.writeBytes(FAKE_HANDSHAKE);
        ctx.writeAndFlush((Object)handshake);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            Debug.log((String)"Depenizen now connected to Bungee server.");
            BungeeBridge.instance.lastPacketReceived = System.currentTimeMillis();
            BungeeBridge.instance.sendPacket(new MyInfoPacketOut(Bukkit.getPort()));
            BungeeBridge.instance.sendPacket(new ControlsProxyPingPacketOut(BungeeBridge.instance.controlsProxyPing));
            BungeeBridge.instance.sendPacket(new ControlsProxyCommandPacketOut(BungeeBridge.instance.controlsProxyCommand));
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
                BungeeBridge.instance.connected = true;
            }, 10L);
        }, 30L);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf m = (ByteBuf)msg;
        this.packetBuffer.writeBytes(m);
        m.release();
        while (true) {
            if (this.currentStage == Stage.AWAIT_HEADER) {
                if (this.packetBuffer.readableBytes() < 8) {
                    return;
                }
                this.waitingLength = this.packetBuffer.readInt();
                this.packetId = this.packetBuffer.readInt();
                this.currentStage = Stage.AWAIT_DATA;
                if (BungeeBridge.instance.packets.containsKey(this.packetId)) continue;
                this.fail("Invalid packet id: " + this.packetId);
                return;
            }
            if (this.currentStage != Stage.AWAIT_DATA) break;
            if (this.packetBuffer.readableBytes() < this.waitingLength) {
                return;
            }
            try {
                BungeeBridge.instance.lastPacketReceived = System.currentTimeMillis();
                PacketIn packet = BungeeBridge.instance.packets.get(this.packetId);
                packet.process(this.packetBuffer);
                this.currentStage = Stage.AWAIT_HEADER;
                this.reallocateBuf(ctx);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.fail("Internal exception.");
                return;
            }
        }
    }

    public static enum Stage {
        AWAIT_HEADER,
        AWAIT_DATA;

    }
}

