/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerEntersTownScriptEvent;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerExitsTownScriptEvent;
import com.denizenscript.depenizen.bukkit.objects.factions.NationTag;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.denizenscript.depenizen.bukkit.properties.towny.TownyCuboidProperties;
import com.denizenscript.depenizen.bukkit.properties.towny.TownyLocationProperties;
import com.denizenscript.depenizen.bukkit.properties.towny.TownyPlayerProperties;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Town;

public class TownyBridge
extends Bridge {
    @Override
    public void init() {
        ObjectFetcher.registerWithObjectFetcher(TownTag.class);
        ObjectFetcher.registerWithObjectFetcher(NationTag.class);
        PropertyParser.registerProperty(TownyPlayerProperties.class, PlayerTag.class);
        PropertyParser.registerProperty(TownyLocationProperties.class, LocationTag.class);
        PropertyParser.registerProperty(TownyCuboidProperties.class, CuboidTag.class);
        ScriptEvent.registerScriptEvent((ScriptEvent)new PlayerEntersTownScriptEvent());
        ScriptEvent.registerScriptEvent((ScriptEvent)new PlayerExitsTownScriptEvent());
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                TownyBridge.this.townyTagEvent(event);
            }
        }, (String[])new String[]{"towny"});
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                TownyBridge.this.townTagEvent(event);
            }
        }, (String[])new String[]{"town"});
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                TownyBridge.this.nationTagEvent(event);
            }
        }, (String[])new String[]{"nation"});
    }

    public void townyTagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("list_towns")) {
            ListTag towns = new ListTag();
            if (attribute.hasContext(1)) {
                try {
                    for (Town town : TownyAPI.getInstance().getDataSource().getWorld(attribute.getContext(1).replace("w@", "")).getTowns().values()) {
                        towns.addObject((ObjectTag)new TownTag(town));
                    }
                }
                catch (NotRegisteredException e) {
                    attribute.echoError("World specified is not a registered towny world!");
                    return;
                }
            } else {
                for (Town town : TownyUniverse.getInstance().getTowns()) {
                    towns.addObject((ObjectTag)new TownTag(town));
                }
            }
            event.setReplacedObject(towns.getObjectAttribute(attribute.fulfill(1)));
        }
    }

    public void townTagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes();
        if (attribute.hasContext(1)) {
            if (!TownTag.matches(attribute.getContext(1))) {
                attribute.echoError("Could not match '" + attribute.getContext(1) + "' to a valid town!");
                return;
            }
            TownTag town = (TownTag)attribute.contextAsType(1, TownTag.class);
            if (town != null) {
                event.setReplacedObject(town.getObjectAttribute(attribute.fulfill(1)));
            } else {
                attribute.echoError("Unknown town '" + attribute.getContext(1) + "' for town[] tag.");
            }
        }
    }

    public void nationTagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes();
        if (attribute.hasContext(1)) {
            if (!NationTag.matches(attribute.getContext(1))) {
                attribute.echoError("Could not match '" + attribute.getContext(1) + "' to a valid nation!");
                return;
            }
            NationTag nation = (NationTag)attribute.contextAsType(1, NationTag.class);
            if (nation != null) {
                event.setReplacedObject(nation.getObjectAttribute(attribute.fulfill(1)));
            } else {
                attribute.echoError("Unknown nation '" + attribute.getContext(1) + "' for nation[] tag.");
            }
        }
    }
}

