/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.commands.playerpoints.PlayerPointsCommand;
import com.denizenscript.depenizen.bukkit.properties.playerpoints.PlayerPointsPlayerProperties;
import java.util.Collection;
import java.util.TreeSet;
import java.util.UUID;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.models.SortedPlayer;
import org.black_ixx.playerpoints.storage.StorageHandler;

public class PlayerPointsBridge
extends Bridge {
    public static PlayerPointsBridge instance;

    @Override
    public void init() {
        instance = this;
        Denizen.getInstance().commandRegistry.registerCommand(PlayerPointsCommand.class);
        PropertyParser.registerProperty(PlayerPointsPlayerProperties.class, PlayerTag.class);
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                PlayerPointsBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"playerpoints"});
    }

    public ListTag getLeaders() {
        Collection players = ((StorageHandler)((PlayerPoints)this.plugin).getModuleForClass(StorageHandler.class)).getPlayers();
        TreeSet<SortedPlayer> sorted = new TreeSet<SortedPlayer>();
        for (String name : players) {
            int points = ((PlayerPoints)this.plugin).getAPI().look(UUID.fromString(name));
            sorted.add(new SortedPlayer(name, points));
        }
        ListTag result = new ListTag();
        for (SortedPlayer player : sorted) {
            result.addObject((ObjectTag)new PlayerTag(UUID.fromString(player.getName())));
        }
        return result;
    }

    public void tagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("leaders")) {
            event.setReplacedObject(this.getLeaders().getObjectAttribute(attribute.fulfill(1)));
        }
    }
}

