/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Bridge;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderAPIBridge
extends Bridge {
    @Override
    public void init() {
        if (!new PlaceholderHook().register()) {
            Debug.echoError((String)"Failed to register placeholder for identifier 'denizen'! Denizen PlaceholderAPI placeholders will not function.");
        }
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                PlaceholderAPIBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"placeholder"});
    }

    public void tagEvent(ReplaceableTagEvent event) {
        Player player;
        Attribute attribute = event.getAttributes();
        String placeholder = attribute.getContext(1);
        if (CoreUtilities.toLowerCase((String)placeholder).startsWith("denizen_")) {
            Debug.echoError((String)"Cannot use <placeholder[]> tags with 'denizen' prefix!");
            return;
        }
        attribute = attribute.fulfill(1);
        Player player2 = player = ((BukkitTagContext)event.getContext()).player != null ? ((BukkitTagContext)event.getContext()).player.getPlayerEntity() : null;
        if (attribute.matches("player") && attribute.hasContext(1) && PlayerTag.matches((String)attribute.getContext(1))) {
            player = ((PlayerTag)attribute.contextAsType(1, PlayerTag.class)).getPlayerEntity();
            attribute.fulfill(1);
        }
        event.setReplacedObject(new ElementTag(PlaceholderAPI.setPlaceholders((Player)player, (String)("%" + placeholder + "%"))).getObjectAttribute(attribute));
    }

    private static class PlaceholderHook
    extends PlaceholderExpansion {
        private PlaceholderHook() {
        }

        public boolean canRegister() {
            return true;
        }

        public boolean persist() {
            return true;
        }

        public String getAuthor() {
            return "The DenizenScript Team";
        }

        public String getIdentifier() {
            return "denizen";
        }

        public String getVersion() {
            return "2.0.0";
        }

        public String onRequest(OfflinePlayer player, String identifier) {
            return TagManager.tag((String)identifier, (TagContext)new BukkitTagContext(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player), null, null, false, null));
        }
    }
}

