/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.commands.jobs.JobsCommand;
import com.denizenscript.depenizen.bukkit.objects.jobs.JobsJobTag;
import com.denizenscript.depenizen.bukkit.properties.jobs.JobPlayer;
import com.denizenscript.depenizen.bukkit.properties.jobs.JobsPlayerProperties;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;

public class JobsBridge
extends Bridge {
    @Override
    public void init() {
        ObjectFetcher.registerWithObjectFetcher(JobsJobTag.class);
        PropertyParser.registerProperty(JobPlayer.class, JobsJobTag.class);
        PropertyParser.registerProperty(JobsPlayerProperties.class, PlayerTag.class);
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                JobsBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"jobs"});
        Denizen.getInstance().commandRegistry.registerCommand(JobsCommand.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes();
        JobsJobTag j = null;
        if (attribute.hasContext(1)) {
            if (!JobsJobTag.matches(attribute.getContext(1))) {
                attribute.echoError("Could not match '" + attribute.getContext(1) + "' to a valid job!");
                return;
            }
            j = (JobsJobTag)attribute.contextAsType(1, JobsJobTag.class);
        } else {
            ListTag jobList = new ListTag();
            for (Job jb : Jobs.getJobs()) {
                jobList.addObject((ObjectTag)new JobsJobTag(jb));
            }
            event.setReplacedObject(jobList.getObjectAttribute(attribute.fulfill(1)));
        }
        if (j == null) {
            attribute.echoError("Invalid or missing job!");
            return;
        }
        event.setReplacedObject(j.getObjectAttribute(attribute.fulfill(1)));
    }
}

