/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.objects.factions.FactionTag;
import com.denizenscript.depenizen.bukkit.properties.factions.FactionsLocationProperties;
import com.denizenscript.depenizen.bukkit.properties.factions.FactionsNPCProperties;
import com.denizenscript.depenizen.bukkit.properties.factions.FactionsPlayerProperties;
import com.denizenscript.depenizen.bukkit.utilities.BridgeLoadException;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;

public class FactionsBridge
extends Bridge {
    @Override
    public void init() {
        if (this.plugin.getDescription().getVersion().startsWith("1.")) {
            throw new BridgeLoadException("Only official modern Factions versions are supported.");
        }
        ObjectFetcher.registerWithObjectFetcher(FactionTag.class);
        PropertyParser.registerProperty(FactionsNPCProperties.class, NPCTag.class);
        PropertyParser.registerProperty(FactionsPlayerProperties.class, PlayerTag.class);
        PropertyParser.registerProperty(FactionsLocationProperties.class, LocationTag.class);
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                FactionsBridge.this.factionTagEvent(event);
            }
        }, (String[])new String[]{"faction"});
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                FactionsBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"factions"});
    }

    public void factionTagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes().fulfill(1);
        String nameOrId = attribute.getContext(1);
        Faction f = FactionColl.get().getByName(nameOrId);
        if (f == null && FactionColl.get().containsId((Object)nameOrId)) {
            f = (Faction)FactionColl.get().get((Object)nameOrId);
        }
        if (f != null) {
            event.setReplacedObject(new FactionTag(f).getObjectAttribute(attribute.fulfill(1)));
        }
    }

    public void tagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("list_factions")) {
            ListTag factions = new ListTag();
            for (Faction f : FactionColl.get().getAll()) {
                factions.addObject((ObjectTag)new FactionTag(f));
            }
            event.setReplacedObject(factions.getObjectAttribute(attribute.fulfill(1)));
        }
    }
}

