/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.events.essentials.PlayerAFKStatusScriptEvent;
import com.denizenscript.depenizen.bukkit.events.essentials.PlayerBalanceChangeScriptEvent;
import com.denizenscript.depenizen.bukkit.events.essentials.PlayerGodModeStatusScriptEvent;
import com.denizenscript.depenizen.bukkit.events.essentials.PlayerJailStatusScriptEvent;
import com.denizenscript.depenizen.bukkit.events.essentials.PlayerMuteStatusScriptEvent;
import com.denizenscript.depenizen.bukkit.properties.essentials.EssentialsItemProperties;
import com.denizenscript.depenizen.bukkit.properties.essentials.EssentialsPlayerProperties;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.commands.WarpNotFoundException;
import net.ess3.api.InvalidWorldException;
import org.bukkit.Location;

public class EssentialsBridge
extends Bridge {
    public static EssentialsBridge instance;

    @Override
    public void init() {
        instance = this;
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                EssentialsBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"essentials"});
        ScriptEvent.registerScriptEvent((ScriptEvent)new PlayerAFKStatusScriptEvent());
        ScriptEvent.registerScriptEvent((ScriptEvent)new PlayerGodModeStatusScriptEvent());
        ScriptEvent.registerScriptEvent((ScriptEvent)new PlayerJailStatusScriptEvent());
        ScriptEvent.registerScriptEvent((ScriptEvent)new PlayerMuteStatusScriptEvent());
        ScriptEvent.registerScriptEvent((ScriptEvent)new PlayerBalanceChangeScriptEvent());
        PropertyParser.registerProperty(EssentialsPlayerProperties.class, PlayerTag.class);
        PropertyParser.registerProperty(EssentialsItemProperties.class, ItemTag.class);
    }

    public void tagEvent(ReplaceableTagEvent event) {
        Essentials essentials;
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("warp") && attribute.hasContext(1)) {
            essentials = (Essentials)this.plugin;
            try {
                Location loc = essentials.getWarps().getWarp(attribute.getContext(1));
                event.setReplacedObject(new LocationTag(loc).getObjectAttribute(attribute.fulfill(1)));
            }
            catch (WarpNotFoundException e) {
                attribute.echoError("Warp not found");
            }
            catch (InvalidWorldException e) {
                attribute.echoError("Invalid world for getting warp");
            }
        }
        if (attribute.startsWith("list_warps")) {
            essentials = (Essentials)this.plugin;
            ListTag warps = new ListTag();
            warps.addAll(essentials.getWarps().getList());
            event.setReplacedObject(warps.getObjectAttribute(attribute.fulfill(1)));
        }
    }
}

