/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.bridges.ASkyBlockBridge;
import com.denizenscript.depenizen.bukkit.bridges.AreaShopBridge;
import com.denizenscript.depenizen.bukkit.bridges.BetonQuestBridge;
import com.denizenscript.depenizen.bukkit.bridges.BigDoorsBridge;
import com.denizenscript.depenizen.bukkit.bridges.BossShopBridge;
import com.denizenscript.depenizen.bukkit.bridges.CrackShotBridge;
import com.denizenscript.depenizen.bukkit.bridges.EffectLibBridge;
import com.denizenscript.depenizen.bukkit.bridges.EssentialsBridge;
import com.denizenscript.depenizen.bukkit.bridges.FactionsBridge;
import com.denizenscript.depenizen.bukkit.bridges.GriefPreventionBridge;
import com.denizenscript.depenizen.bukkit.bridges.JobsBridge;
import com.denizenscript.depenizen.bukkit.bridges.LibsDisguisesBridge;
import com.denizenscript.depenizen.bukkit.bridges.LuckPermsBridge;
import com.denizenscript.depenizen.bukkit.bridges.MagicSpellsBridge;
import com.denizenscript.depenizen.bukkit.bridges.McMMOBridge;
import com.denizenscript.depenizen.bukkit.bridges.MobArenaBridge;
import com.denizenscript.depenizen.bukkit.bridges.MythicMobsBridge;
import com.denizenscript.depenizen.bukkit.bridges.NoCheatPlusBridge;
import com.denizenscript.depenizen.bukkit.bridges.NoteBlockAPIBridge;
import com.denizenscript.depenizen.bukkit.bridges.OpenTerrainGeneratorBridge;
import com.denizenscript.depenizen.bukkit.bridges.PVPArenaBridge;
import com.denizenscript.depenizen.bukkit.bridges.PVPStatsBridge;
import com.denizenscript.depenizen.bukkit.bridges.PlaceholderAPIBridge;
import com.denizenscript.depenizen.bukkit.bridges.PlayerPointsBridge;
import com.denizenscript.depenizen.bukkit.bridges.PlotSquaredBridge;
import com.denizenscript.depenizen.bukkit.bridges.QuestsBridge;
import com.denizenscript.depenizen.bukkit.bridges.ResidenceBridge;
import com.denizenscript.depenizen.bukkit.bridges.SentinelBridge;
import com.denizenscript.depenizen.bukkit.bridges.ShopkeepersBridge;
import com.denizenscript.depenizen.bukkit.bridges.SkillAPIBridge;
import com.denizenscript.depenizen.bukkit.bridges.TerrainControlBridge;
import com.denizenscript.depenizen.bukkit.bridges.TownyBridge;
import com.denizenscript.depenizen.bukkit.bridges.TownyChatBridge;
import com.denizenscript.depenizen.bukkit.bridges.VampireBridge;
import com.denizenscript.depenizen.bukkit.bridges.ViaVersionBridge;
import com.denizenscript.depenizen.bukkit.bridges.VotifierBridge;
import com.denizenscript.depenizen.bukkit.bridges.WorldEditBridge;
import com.denizenscript.depenizen.bukkit.bridges.WorldGuardBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.utilities.BridgeLoadException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Depenizen
extends JavaPlugin {
    public static Depenizen instance;
    public HashMap<String, Supplier<Bridge>> allBridges = new HashMap();
    public HashMap<String, Bridge> loadedBridges = new HashMap();

    public void onEnable() {
        Debug.log((String)"Depenizen loading...");
        this.saveDefaultConfig();
        instance = this;
        this.registerCoreBridges();
        for (Map.Entry<String, Supplier<Bridge>> bridge : this.allBridges.entrySet()) {
            this.loadBridge(bridge.getKey(), bridge.getValue());
        }
        try {
            this.checkLoadBungeeBridge();
        }
        catch (Throwable ex) {
            Debug.echoError((String)"Cannot load Depenizen-Bungee bridge: Internal exception was thrown!");
            Debug.echoError((Throwable)ex);
        }
        Debug.log((String)("Depenizen loaded! " + this.loadedBridges.size() + " plugin bridge(s) loaded (of " + this.allBridges.size() + " available)"));
    }

    public void onDisable() {
        if (BungeeBridge.instance != null && BungeeBridge.instance.connected) {
            BungeeBridge.instance.onShutdown();
        }
        Denizen.getInstance().onDisable();
    }

    public void checkLoadBungeeBridge() {
        String bungeeServer = this.getConfig().getString("Bungee server address", "none");
        if (CoreUtilities.equalsIgnoreCase((String)bungeeServer, (String)"none")) {
            Debug.log((String)"<G>Depenizen will not load bungee bridge.");
            return;
        }
        new BungeeBridge().init(bungeeServer, this.getConfig().getInt("Bungee server port", 25565));
        Debug.log((String)"Depenizen loaded bungee bridge!");
    }

    public void loadBridge(String name, Supplier<Bridge> bridgeSupplier) {
        Bridge newBridge;
        Plugin plugin = Bukkit.getPluginManager().getPlugin(name);
        if (plugin == null) {
            Debug.log((String)("<G>Depenizen will not load bridge for '" + name + "'."));
            return;
        }
        try {
            newBridge = bridgeSupplier.get();
        }
        catch (Throwable ex) {
            Debug.echoError((String)("Cannot load Depenizen bridge for '" + name + "': fundamental loading error:"));
            Debug.echoError((Throwable)ex);
            return;
        }
        newBridge.name = name;
        newBridge.plugin = plugin;
        try {
            newBridge.init();
        }
        catch (BridgeLoadException ex) {
            Debug.echoError((String)("Cannot load Depenizen bridge for '" + name + "': " + ex.getMessage()));
            return;
        }
        catch (Throwable ex) {
            Debug.echoError((String)("Cannot load Depenizen bridge for '" + name + "': Internal exception was thrown!"));
            Debug.echoError((Throwable)ex);
            return;
        }
        this.loadedBridges.put(name, newBridge);
        Debug.log((String)("Depenizen loaded bridge for '" + name + "'!"));
    }

    public void registerCoreBridges() {
        this.registerBridge("AreaShop", () -> new AreaShopBridge());
        this.registerBridge("ASkyBlock", () -> new ASkyBlockBridge());
        this.registerBridge("BigDoors", () -> new BigDoorsBridge());
        this.registerBridge("BossShopPro", () -> new BossShopBridge());
        this.registerBridge("CrackShot", () -> new CrackShotBridge());
        this.registerBridge("EffectLib", () -> new EffectLibBridge());
        this.registerBridge("Essentials", () -> new EssentialsBridge());
        this.registerBridge("Factions", () -> new FactionsBridge());
        this.registerBridge("GriefPrevention", () -> new GriefPreventionBridge());
        this.registerBridge("Jobs", () -> new JobsBridge());
        this.registerBridge("LibsDisguises", () -> new LibsDisguisesBridge());
        this.registerBridge("LuckPerms", () -> new LuckPermsBridge());
        this.registerBridge("MagicSpells", () -> new MagicSpellsBridge());
        this.registerBridge("mcMMO", () -> new McMMOBridge());
        this.registerBridge("MobArena", () -> new MobArenaBridge());
        this.registerBridge("MythicMobs", () -> new MythicMobsBridge());
        this.registerBridge("NoCheatPlus", () -> new NoCheatPlusBridge());
        this.registerBridge("NoteBlockAPI", () -> new NoteBlockAPIBridge());
        this.registerBridge("OpenTerrainGenerator", () -> new OpenTerrainGeneratorBridge());
        this.registerBridge("PlaceholderAPI", () -> new PlaceholderAPIBridge());
        this.registerBridge("PlayerPoints", () -> new PlayerPointsBridge());
        this.registerBridge("PlotSquared", () -> new PlotSquaredBridge());
        this.registerBridge("PVPArena", () -> new PVPArenaBridge());
        this.registerBridge("PVPStats", () -> new PVPStatsBridge());
        this.registerBridge("Quests", () -> new QuestsBridge());
        this.registerBridge("Residence", () -> new ResidenceBridge());
        this.registerBridge("Sentinel", () -> new SentinelBridge());
        this.registerBridge("Shopkeepers", () -> new ShopkeepersBridge());
        this.registerBridge("SkillAPI", () -> new SkillAPIBridge());
        this.registerBridge("TerrainControl", () -> new TerrainControlBridge());
        this.registerBridge("TownyChat", () -> new TownyChatBridge());
        this.registerBridge("Towny", () -> new TownyBridge());
        this.registerBridge("Vampire", () -> new VampireBridge());
        this.registerBridge("ViaVersion", () -> new ViaVersionBridge());
        this.registerBridge("Votifier", () -> new VotifierBridge());
        this.registerBridge("WorldEdit", () -> new WorldEditBridge());
        this.registerBridge("WorldGuard", () -> new WorldGuardBridge());
        this.registerBridge("BetonQuest", () -> new BetonQuestBridge());
    }

    public void registerBridge(String name, Supplier<Bridge> bridgeSupplier) {
        this.allBridges.put(name, bridgeSupplier);
    }
}

