/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.xseries.particles;

import com.archyx.aureliumskills.xseries.particles.XParticle;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class ParticleDisplay
implements Cloneable {
    private static final boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    private static final Axis[] DEFAULT_ROTATION_ORDER = new Axis[]{Axis.X, Axis.Y, Axis.Z};
    private static final Particle DEFAULT_PARTICLE = Particle.CLOUD;
    public int count;
    public double extra;
    public boolean force;
    @Nonnull
    private Particle particle;
    @Nullable
    private Location location;
    @Nullable
    private Callable<Location> locationCaller;
    @Nullable
    private Vector rotation;
    @Nullable
    private Vector offset;
    @Nonnull
    private Axis[] rotationOrder = DEFAULT_ROTATION_ORDER;
    @Nullable
    private Object data;
    @Nullable
    private Predicate<Location> onSpawn;

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Callable<Location> locationCaller, @Nullable Location location, int count, @Nonnull Vector offset, double extra, boolean force) {
        this.particle = Objects.requireNonNull(particle, "Particle cannot be null");
        this.location = location;
        this.locationCaller = locationCaller;
        this.count = count;
        this.offset = Objects.requireNonNull(offset, "Offset cannot be null");
        this.extra = extra;
        this.force = force;
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Callable<Location> locationCaller, @Nullable Location location, int count, @Nonnull Vector offset, double extra) {
        this(particle, locationCaller, location, count, offset, extra, false);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int count, Vector offset) {
        this(particle, null, location, count, offset, 0.0);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int count) {
        this(particle, location, count, new Vector());
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location) {
        this(particle, location, 0);
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, int r, int g, int b, float size) {
        ParticleDisplay dust = new ParticleDisplay(Particle.REDSTONE, null, location, 1, new Vector(), 0.0);
        dust.data = new float[]{r, g, b, size};
        return dust;
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, @Nonnull Color color, float size) {
        return ParticleDisplay.colored(location, color.getRed(), color.getGreen(), color.getBlue(), size);
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        return new ParticleDisplay(particle, null, location, 1, new Vector(), 0.0);
    }

    @Nonnull
    public static ParticleDisplay of(@Nonnull Particle particle) {
        return ParticleDisplay.simple(null, particle);
    }

    @Nonnull
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay display = ParticleDisplay.simple(location, particle);
        display.spawn();
        return display;
    }

    public static ParticleDisplay fromConfig(@Nullable Location location, @Nonnull ConfigurationSection config) {
        ParticleDisplay display = new ParticleDisplay(DEFAULT_PARTICLE, location);
        return ParticleDisplay.edit(display, config);
    }

    @Nonnull
    public static ParticleDisplay edit(@Nonnull ParticleDisplay display, @Nonnull ConfigurationSection config) {
        Material material;
        String rotationOrder;
        String[] rotations;
        String rotation;
        String offset;
        Objects.requireNonNull(display, "Cannot edit a null particle display");
        Objects.requireNonNull(config, "Cannot parse ParticleDisplay from a null config section");
        String particleName = config.getString("particle");
        Particle particle = particleName == null ? null : XParticle.getParticle(particleName);
        int count = config.getInt("count");
        double extra = config.getDouble("extra");
        boolean force = config.getBoolean("force");
        if (particle != null) {
            display.particle = particle;
        }
        if (count != 0) {
            display.withCount(count);
        }
        if (extra != 0.0) {
            display.withExtra(extra);
        }
        if (force) {
            display.withForce(force);
        }
        if ((offset = config.getString("offset")) != null) {
            String[] offsets = StringUtils.split((String)StringUtils.deleteWhitespace((String)offset), (char)',');
            if (offsets.length >= 3) {
                double offsetx = NumberUtils.toDouble((String)offsets[0]);
                double offsety = NumberUtils.toDouble((String)offsets[1]);
                double offsetz = NumberUtils.toDouble((String)offsets[2]);
                display.offset(offsetx, offsety, offsetz);
            } else {
                double masterOffset = NumberUtils.toDouble((String)offsets[0]);
                display.offset(masterOffset);
            }
        }
        if ((rotation = config.getString("rotation")) != null && (rotations = StringUtils.split((String)StringUtils.deleteWhitespace((String)rotation), (char)',')).length >= 3) {
            double x = Math.toRadians(NumberUtils.toDouble((String)rotations[0]));
            double y = Math.toRadians(NumberUtils.toDouble((String)rotations[1]));
            double z = Math.toRadians(NumberUtils.toDouble((String)rotations[2]));
            display.rotation = new Vector(x, y, z);
        }
        if ((rotationOrder = config.getString("rotation-order")) != null) {
            rotationOrder = StringUtils.deleteWhitespace((String)rotationOrder).toUpperCase(Locale.ENGLISH);
            display.rotationOrder(Axis.valueOf(String.valueOf(rotationOrder.charAt(0))), Axis.valueOf(String.valueOf(rotationOrder.charAt(1))), Axis.valueOf(String.valueOf(rotationOrder.charAt(2))));
        }
        String color = config.getString("color");
        String blockdata = config.getString("blockdata");
        String item = config.getString("itemstack");
        String materialdata = config.getString("materialdata");
        if (color != null) {
            String[] colors = StringUtils.split((String)StringUtils.deleteWhitespace((String)color), (char)',');
            if (colors.length >= 3) {
                display.data = new float[]{NumberUtils.toInt((String)colors[0]), NumberUtils.toInt((String)colors[1]), NumberUtils.toInt((String)colors[2]), (float)config.getDouble("size", 1.0)};
            }
        } else if (blockdata != null) {
            Material material2 = Material.getMaterial((String)blockdata);
            if (material2 != null && material2.isBlock()) {
                display.data = material2.createBlockData();
            }
        } else if (item != null) {
            Material material3 = Material.getMaterial((String)item);
            if (material3 != null && material3.isItem()) {
                display.data = new ItemStack(material3, 1);
            }
        } else if (materialdata != null && (material = Material.getMaterial((String)materialdata)) != null && material.isBlock()) {
            display.data = material.getData();
        }
        return display;
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Vector rotateAround(@Nonnull Vector location, @Nonnull Axis axis, @Nonnull Vector rotation) {
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        Objects.requireNonNull(rotation, "Rotation vector cannot be null");
        switch (axis) {
            case X: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getX());
            }
            case Y: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getY());
            }
            case Z: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getZ());
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public static Vector rotateAround(@Nonnull Vector location, double x, double y, double z) {
        ParticleDisplay.rotateAround(location, Axis.X, x);
        ParticleDisplay.rotateAround(location, Axis.Y, y);
        ParticleDisplay.rotateAround(location, Axis.Z, z);
        return location;
    }

    public static Vector rotateAround(@Nonnull Vector location, @Nonnull Axis axis, double angle) {
        Objects.requireNonNull(location, "Cannot rotate a null location");
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        if (angle == 0.0) {
            return location;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        switch (axis) {
            case X: {
                double y = location.getY() * cos - location.getZ() * sin;
                double z = location.getY() * sin + location.getZ() * cos;
                return location.setY(y).setZ(z);
            }
            case Y: {
                double x = location.getX() * cos + location.getZ() * sin;
                double z = location.getX() * -sin + location.getZ() * cos;
                return location.setX(x).setZ(z);
            }
            case Z: {
                double x = location.getX() * cos - location.getY() * sin;
                double y = location.getX() * sin + location.getY() * cos;
                return location.setX(x).setY(y);
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public ParticleDisplay onSpawn(@Nullable Predicate<Location> onSpawn) {
        this.onSpawn = onSpawn;
        return this;
    }

    public void setParticle(@Nonnull Particle particle) {
        this.particle = Objects.requireNonNull(particle, "Particle cannot be null");
    }

    @Nonnull
    public Location rotate(@Nonnull Location location, double x, double y, double z) {
        if (location == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.rotation == null) {
            return ParticleDisplay.cloneLocation(location).add(x, y, z);
        }
        Vector rotate = new Vector(x, y, z);
        ParticleDisplay.rotateAround(rotate, this.rotationOrder[0], this.rotation);
        ParticleDisplay.rotateAround(rotate, this.rotationOrder[1], this.rotation);
        ParticleDisplay.rotateAround(rotate, this.rotationOrder[2], this.rotation);
        return ParticleDisplay.cloneLocation(location).add(rotate);
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public String toString() {
        return "ParticleDisplay:[Particle=" + this.particle + ", Count=" + this.count + ", Offset:{" + this.offset.getX() + ", " + this.offset.getY() + ", " + this.offset.getZ() + "}, Extra=" + this.extra + "Force=" + this.force + ", Data=" + (this.data == null ? "null" : (this.data instanceof float[] ? Arrays.toString((float[])this.data) : this.data));
    }

    @Nonnull
    public ParticleDisplay withCount(int count) {
        this.count = count;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double extra) {
        this.extra = extra;
        return this;
    }

    @Nonnull
    public ParticleDisplay withForce(boolean force) {
        this.force = force;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float size) {
        this.data = new float[]{color.getRed(), color.getGreen(), color.getBlue(), size};
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull BlockData blockData) {
        this.data = blockData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull MaterialData materialData) {
        this.data = materialData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withItem(@Nonnull ItemStack item) {
        this.data = item;
        return this;
    }

    @Nullable
    public Vector getOffset() {
        return this.offset;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nonnull Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> locationCaller) {
        this.locationCaller = locationCaller;
        return this;
    }

    public ParticleDisplay rotationOrder(@Nonnull Axis first, @Nonnull Axis second, @Nonnull Axis third) {
        Objects.requireNonNull(first, "First rotation order axis is null");
        Objects.requireNonNull(second, "Second rotation order axis is null");
        Objects.requireNonNull(third, "Third rotation order axis is null");
        this.rotationOrder = new Axis[]{first, second, third};
        return this;
    }

    @Nullable
    public Location getLocation() {
        try {
            return this.locationCaller == null ? this.location : this.locationCaller.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.location;
        }
    }

    public void setLocation(@Nullable Location location) {
        this.location = location;
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Entity entity) {
        return this.face(Objects.requireNonNull(entity, "Cannot face null entity").getLocation());
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Location location) {
        Objects.requireNonNull(location, "Cannot face null location");
        this.rotation = new Vector(Math.toRadians(location.getPitch() + 90.0f), Math.toRadians(-location.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double x, double y, double z) {
        return this.location == null ? null : ParticleDisplay.cloneLocation(this.location).add(x, y, z);
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double x, double y, double z) {
        ParticleDisplay display = this.clone();
        if (this.location == null) {
            return display;
        }
        display.location.add(x, y, z);
        return display;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay display = new ParticleDisplay(this.particle, this.locationCaller, this.location == null ? null : ParticleDisplay.cloneLocation(this.location), this.count, this.offset.clone(), this.extra, this.force);
        if (this.rotation != null) {
            display.rotation = this.rotation.clone();
        }
        display.rotationOrder = this.rotationOrder;
        display.onSpawn(this.onSpawn);
        display.data = this.data;
        return display;
    }

    @Nonnull
    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay rotate(double x, double y, double z) {
        return this.rotate(new Vector(x, y, z));
    }

    @Nonnull
    public ParticleDisplay offset(double x, double y, double z) {
        return this.offset(new Vector(x, y, z));
    }

    @Nonnull
    public ParticleDisplay offset(@Nonnull Vector offset) {
        this.offset = Objects.requireNonNull(offset, "Particle offset cannot be null");
        return this;
    }

    @Nullable
    public Vector getRotation() {
        return this.rotation;
    }

    public void setRotation(@Nullable Vector rotation) {
        this.rotation = rotation;
    }

    @Nonnull
    public ParticleDisplay offset(double offset) {
        return this.offset(offset, offset, offset);
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.getLocation());
    }

    @Nonnull
    public Location spawn(@Nonnull Vector location) {
        Objects.requireNonNull(location, "Cannot add xyz of null vector to ParticleDisplay");
        return this.spawn(location.getX(), location.getY(), location.getZ());
    }

    @Nonnull
    public Location spawn(double x, double y, double z) {
        return this.spawn(this.rotate(this.getLocation(), x, y, z));
    }

    @Nonnull
    public Location spawn(@Nonnull Location loc) {
        return this.spawn(loc, null);
    }

    @Nonnull
    public Location spawn(@Nonnull Location loc, Player ... players) {
        if (loc == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.onSpawn != null && !this.onSpawn.test(loc)) {
            return loc;
        }
        World world = loc.getWorld();
        double offsetx = this.offset.getX();
        double offsety = this.offset.getY();
        double offsetz = this.offset.getZ();
        if (this.data != null && this.data instanceof float[]) {
            float[] datas = (float[])this.data;
            if (ISFLAT && this.particle.getDataType() == Particle.DustOptions.class) {
                Particle.DustOptions dust = new Particle.DustOptions(org.bukkit.Color.fromRGB((int)((int)datas[0]), (int)((int)datas[1]), (int)((int)datas[2])), datas[3]);
                if (players == null) {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, (Object)dust, this.force);
                } else {
                    for (Player player : players) {
                        player.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, (Object)dust);
                    }
                }
            } else if (this.isDirectional()) {
                float[] rgb = new float[]{datas[0] / 255.0f, datas[1] / 255.0f, datas[2] / 255.0f};
                if (players == null) {
                    if (ISFLAT) {
                        world.spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3], null, this.force);
                    } else {
                        world.spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3], null);
                    }
                } else {
                    for (Player player : players) {
                        player.spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3]);
                    }
                }
            } else if (players == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, null, this.force);
                } else {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, null);
                }
            } else {
                for (Player player : players) {
                    player.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra);
                }
            }
        } else {
            Object datas;
            Object object = datas = this.particle.getDataType().isInstance(this.data) ? this.data : null;
            if (players == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, datas, this.force);
                } else {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, datas);
                }
            } else {
                for (Player player : players) {
                    player.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, datas);
                }
            }
        }
        return loc;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

