/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.xseries;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public enum XPotion {
    ABSORPTION("ABSORB"),
    BAD_OMEN("OMEN_BAD", "PILLAGER"),
    BLINDNESS("BLIND"),
    CONDUIT_POWER("CONDUIT", "POWER_CONDUIT"),
    CONFUSION("NAUSEA", "SICKNESS", "SICK"),
    DAMAGE_RESISTANCE("RESISTANCE", "ARMOR", "DMG_RESIST", "DMG_RESISTANCE"),
    DOLPHINS_GRACE("DOLPHIN", "GRACE"),
    FAST_DIGGING("HASTE", "SUPER_PICK", "DIGFAST", "DIG_SPEED", "QUICK_MINE", "SHARP"),
    FIRE_RESISTANCE("FIRE_RESIST", "RESIST_FIRE", "FIRE_RESISTANCE"),
    GLOWING("GLOW", "SHINE", "SHINY"),
    HARM("INJURE", "DAMAGE", "HARMING", "INFLICT"),
    HEAL("HEALTH", "INSTA_HEAL", "INSTANT_HEAL", "INSTA_HEALTH", "INSTANT_HEALTH"),
    HEALTH_BOOST("BOOST_HEALTH", "BOOST", "HP"),
    HERO_OF_THE_VILLAGE("HERO", "VILLAGE_HERO"),
    HUNGER("STARVE", "HUNGRY"),
    INCREASE_DAMAGE("STRENGTH", "BULL", "STRONG", "ATTACK"),
    INVISIBILITY("INVISIBLE", "VANISH", "INVIS", "DISAPPEAR", "HIDE"),
    JUMP("LEAP", "JUMP_BOOST"),
    LEVITATION("LEVITATE"),
    LUCK("LUCKY"),
    NIGHT_VISION("VISION", "VISION_NIGHT"),
    POISON("VENOM"),
    REGENERATION("REGEN"),
    SATURATION("FOOD"),
    SLOW("SLOWNESS", "SLUGGISH"),
    SLOW_DIGGING("FATIGUE", "DULL", "DIGGING", "SLOW_DIG", "DIG_SLOW"),
    SLOW_FALLING("SLOW_FALL", "FALL_SLOW"),
    SPEED("SPRINT", "RUNFAST", "SWIFT", "FAST"),
    UNLUCK("UNLUCKY"),
    WATER_BREATHING("WATER_BREATH", "UNDERWATER_BREATHING", "UNDERWATER_BREATH", "AIR"),
    WEAKNESS("WEAK"),
    WITHER("DECAY");

    public static final XPotion[] VALUES;
    public static final Set<XPotion> DEBUFFS;
    private final PotionEffectType type = PotionEffectType.getByName((String)this.name());

    private XPotion(String ... aliases) {
        Data.NAMES.put(this.name(), this);
        for (String legacy : aliases) {
            Data.NAMES.put(legacy, this);
        }
    }

    @Nonnull
    private static String format(@Nonnull String name) {
        int len = name.length();
        char[] chs = new char[len];
        int count = 0;
        boolean appendUnderline = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (!(appendUnderline || count == 0 || ch != '-' && ch != ' ' && ch != '_' || chs[count] == '_')) {
                appendUnderline = true;
                continue;
            }
            if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            if (appendUnderline) {
                chs[count++] = 95;
                appendUnderline = false;
            }
            chs[count++] = (char)(ch & 0x5F);
        }
        return new String(chs, 0, count);
    }

    @Nonnull
    public static Optional<XPotion> matchXPotion(@Nonnull String potion) {
        Validate.notEmpty((String)potion, (String)"Cannot match XPotion of a null or empty potion effect type");
        PotionEffectType idType = XPotion.getIdFromString(potion);
        if (idType != null) {
            XPotion type = (XPotion)((Object)Data.NAMES.get(idType.getName()));
            if (type == null) {
                throw new NullPointerException("Unsupported potion effect type ID: " + idType);
            }
            return Optional.of(type);
        }
        return Optional.ofNullable(Data.NAMES.get(XPotion.format(potion)));
    }

    @Nonnull
    public static XPotion matchXPotion(@Nonnull PotionEffectType type) {
        Objects.requireNonNull(type, "Cannot match XPotion of a null potion effect type");
        return (XPotion)((Object)Objects.requireNonNull(Data.NAMES.get(type.getName()), () -> "Unsupported potion effect type: " + type.getName()));
    }

    @Nullable
    private static PotionEffectType getIdFromString(@Nonnull String type) {
        try {
            int id = Integer.parseInt(type);
            return PotionEffectType.getById((int)id);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Nullable
    public static PotionEffect parsePotionEffectFromString(@Nullable String potion) {
        Optional<XPotion> typeOpt;
        if (Strings.isNullOrEmpty((String)potion) || potion.equalsIgnoreCase("none")) {
            return null;
        }
        String[] split = StringUtils.split((String)StringUtils.deleteWhitespace((String)potion), (char)',');
        if (split.length == 0) {
            split = StringUtils.split((String)potion, (char)' ');
        }
        if (!(typeOpt = XPotion.matchXPotion(split[0])).isPresent()) {
            return null;
        }
        PotionEffectType type = typeOpt.get().parsePotionEffectType();
        if (type == null) {
            return null;
        }
        int duration = 2400;
        int amplifier = 0;
        if (split.length > 1) {
            duration = NumberUtils.toInt((String)split[1]) * 20;
            if (split.length > 2) {
                amplifier = NumberUtils.toInt((String)split[2]) - 1;
            }
        }
        return new PotionEffect(type, duration, amplifier);
    }

    public static void addPotionEffectsFromString(@Nonnull Player player, @Nullable List<String> effects) {
        if (effects == null || effects.isEmpty()) {
            return;
        }
        Objects.requireNonNull(player, "Cannot add potion effects to null player");
        for (String effect : effects) {
            PotionEffect potionEffect = XPotion.parsePotionEffectFromString(effect);
            if (potionEffect == null) continue;
            player.addPotionEffect(potionEffect);
        }
    }

    @Nonnull
    public static ThrownPotion throwPotion(@Nonnull LivingEntity entity, @Nullable Color color, PotionEffect ... effects) {
        Objects.requireNonNull(entity, "Cannot throw potion from null entity");
        ItemStack potion = Material.getMaterial((String)"SPLASH_POTION") == null ? new ItemStack(Material.POTION, 1, 16398) : new ItemStack(Material.SPLASH_POTION);
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        meta.setColor(color);
        if (effects != null) {
            for (PotionEffect effect : effects) {
                meta.addCustomEffect(effect, true);
            }
        }
        potion.setItemMeta((ItemMeta)meta);
        ThrownPotion thrownPotion = (ThrownPotion)entity.launchProjectile(ThrownPotion.class);
        thrownPotion.setItem(potion);
        return thrownPotion;
    }

    @Nonnull
    public static ItemStack buildItemWithEffects(@Nonnull Material type, @Nullable Color color, PotionEffect ... effects) {
        Objects.requireNonNull(type, "Cannot build an effected item with null type");
        Validate.isTrue((boolean)XPotion.canHaveEffects(type), (String)("Cannot build item with " + type.name() + " potion type"));
        ItemStack item = new ItemStack(type);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        meta.setColor(color);
        meta.setDisplayName(type == Material.POTION ? "Potion" : (type == Material.SPLASH_POTION ? "Splash Potion" : (type == Material.TIPPED_ARROW ? "Tipped Arrow" : "Lingering Potion")));
        if (effects != null) {
            for (PotionEffect effect : effects) {
                meta.addCustomEffect(effect, true);
            }
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static boolean canHaveEffects(@Nullable Material material) {
        return material != null && (material.name().endsWith("POTION") || material.name().startsWith("TIPPED_ARROW"));
    }

    @Nullable
    public PotionEffectType parsePotionEffectType() {
        return this.type;
    }

    public boolean isSupported() {
        return this.parsePotionEffectType() != null;
    }

    @Nullable
    @Deprecated
    public PotionType getPotionType() {
        PotionEffectType type = this.parsePotionEffectType();
        return type == null ? null : PotionType.getByEffect((PotionEffectType)type);
    }

    @Nullable
    public PotionEffect parsePotion(int duration, int amplifier) {
        PotionEffectType type = this.parsePotionEffectType();
        return type == null ? null : new PotionEffect(type, duration, amplifier);
    }

    public String toString() {
        return WordUtils.capitalize((String)this.name().replace('_', ' ').toLowerCase(Locale.ENGLISH));
    }

    static {
        VALUES = XPotion.values();
        DEBUFFS = Collections.unmodifiableSet(EnumSet.of(BAD_OMEN, new XPotion[]{BLINDNESS, CONFUSION, HARM, HUNGER, LEVITATION, POISON, SLOW, SLOW_DIGGING, UNLUCK, WEAKNESS, WITHER}));
    }

    private static final class Data {
        private static final Map<String, XPotion> NAMES = new HashMap<String, XPotion>();

        private Data() {
        }
    }
}

