/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.util.world;

import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class WorldManager {
    private List<String> blockedWorlds;
    private List<String> disabledWorlds;
    private List<String> blockedCheckBlockReplaceWorlds;
    private final Plugin plugin;

    public WorldManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void loadWorlds() {
        int blockedWorldsLoaded = 0;
        this.blockedWorlds = new LinkedList<String>();
        this.disabledWorlds = new LinkedList<String>();
        this.blockedCheckBlockReplaceWorlds = new LinkedList<String>();
        FileConfiguration config = this.plugin.getConfig();
        for (String blockedWorld : config.getStringList("blocked-worlds")) {
            this.blockedWorlds.add(blockedWorld);
            ++blockedWorldsLoaded;
        }
        for (String blockedWorld : config.getStringList("disabled-worlds")) {
            this.disabledWorlds.add(blockedWorld);
            ++blockedWorldsLoaded;
        }
        for (String blockedWorld : config.getStringList("blocked-check-block-replace-worlds")) {
            this.blockedCheckBlockReplaceWorlds.add(blockedWorld);
            ++blockedWorldsLoaded;
        }
        Bukkit.getLogger().info("[AureliumSkills] Loaded " + blockedWorldsLoaded + " blocked worlds.");
    }

    public boolean isInBlockedWorld(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.disabledWorlds.contains(world.getName()) || this.blockedWorlds.contains(world.getName());
    }

    public boolean isInDisabledWorld(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.disabledWorlds.contains(world.getName());
    }

    public boolean isInBlockedCheckWorld(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.blockedCheckBlockReplaceWorlds.contains(world.getName());
    }

    public boolean isDisabledWorld(World world) {
        return this.disabledWorlds.contains(world.getName());
    }
}

