/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.util.file;

import java.io.File;
import org.apache.commons.lang.math.NumberUtils;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    @Nullable
    public static String renameNoDuplicates(File file, String resultName, File directory) {
        String renamedName;
        int duplicates = 0;
        File[] subFiles = directory.listFiles();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                int fileNameNumber;
                if (subFile.getName().equals(resultName)) {
                    if (1 <= duplicates) break;
                    duplicates = 1;
                    break;
                }
                String baseName = FileUtil.getBaseName(resultName);
                if (!subFile.getName().startsWith(baseName + " (") || (fileNameNumber = NumberUtils.toInt((String)subFile.getName().substring(baseName.length() + 2, baseName.length() + 3)) + 1) <= duplicates) continue;
                duplicates = fileNameNumber;
            }
        }
        if (duplicates == 0) {
            renamedName = resultName;
        } else {
            String resultBase = FileUtil.getBaseName(resultName);
            String resultExtension = FileUtil.getExtension(resultName);
            renamedName = resultBase + " (" + duplicates + ")." + resultExtension;
        }
        if (file.renameTo(new File(file.getParent(), renamedName))) {
            return renamedName;
        }
        return null;
    }

    public static String getBaseName(String fileName) {
        return fileName.split("\\.(?=[^.]+$)")[0];
    }

    public static String getExtension(String fileName) {
        try {
            return fileName.split("\\.(?=[^.]+$)")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return fileName;
        }
    }
}

