/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.util.entity;

import com.archyx.aureliumskills.util.misc.Parser;
import com.archyx.aureliumskills.util.version.VersionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class EntityData
extends Parser {
    private final EntityType type;
    private final boolean glowing;
    private final int fireTicks;
    private final boolean visualFire;
    private final boolean persistent;
    private final List<EntityData> passengers;
    private final boolean invulnerable;
    private final boolean silent;
    private final boolean gravity;
    private final boolean customNameVisible;
    private final String customName;
    private final List<String> scoreboardTags;

    public EntityData(Map<?, ?> data) {
        this.type = EntityType.valueOf((String)this.getString(data, "entity_type"));
        this.glowing = this.getBooleanOrDefault(data, "glowing", false);
        this.fireTicks = this.getIntOrDefault(data, "fire_ticks", 0);
        this.visualFire = this.getBooleanOrDefault(data, "visual_fire", false);
        this.persistent = this.getBooleanOrDefault(data, "persistent", true);
        this.passengers = new ArrayList<EntityData>();
        for (Map<?, ?> passengerData : this.getMapListOrDefault(data, "passengers", new ArrayList())) {
            this.passengers.add(new EntityData(passengerData));
        }
        this.invulnerable = this.getBooleanOrDefault(data, "invulnerable", false);
        this.silent = this.getBooleanOrDefault(data, "silent", false);
        this.gravity = this.getBooleanOrDefault(data, "gravity", true);
        this.customNameVisible = this.getBooleanOrDefault(data, "custom_name_visible", true);
        this.customName = this.getStringOrDefault(data, "custom_name", null);
        this.scoreboardTags = this.getStringListOrDefault(data, "scoreboard_tags", new ArrayList<String>());
    }

    @Nullable
    public Entity spawn(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        Entity entity = world.spawnEntity(location, this.type);
        this.applyData(entity, location);
        return entity;
    }

    protected void applyData(Entity entity, Location location) {
        entity.setGlowing(this.glowing);
        entity.setFireTicks(this.fireTicks);
        if (VersionUtils.isAtLeastVersion(17)) {
            entity.setVisualFire(this.visualFire);
        }
        entity.setPersistent(this.persistent);
        for (EntityData passengerData : this.passengers) {
            Entity passenger = passengerData.spawn(location);
            if (passenger == null) continue;
            entity.addPassenger(passenger);
        }
        entity.setInvulnerable(this.invulnerable);
        entity.setSilent(this.silent);
        entity.setGravity(this.gravity);
        entity.setCustomNameVisible(this.customNameVisible);
        entity.setCustomName(this.customName);
        for (String scoreboardTag : this.scoreboardTags) {
            entity.addScoreboardTag(scoreboardTag);
        }
    }
}

