/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.util.block;

import com.archyx.aureliumskills.xseries.XMaterial;
import org.bukkit.CropState;
import org.bukkit.Material;
import org.bukkit.NetherWartsState;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.material.CocoaPlant;
import org.bukkit.material.Crops;
import org.bukkit.material.NetherWarts;

public class BlockUtil {
    public static boolean isFullyGrown(Block block) {
        if (XMaterial.isNewVersion()) {
            if (block.getBlockData() instanceof Ageable) {
                Ageable crop = (Ageable)block.getBlockData();
                return crop.getMaximumAge() == crop.getAge();
            }
        } else {
            if (block.getState().getData() instanceof Crops) {
                Crops crops = (Crops)block.getState().getData();
                return crops.getState().equals((Object)CropState.RIPE);
            }
            if (block.getState().getData() instanceof NetherWarts) {
                NetherWarts wart = (NetherWarts)block.getState().getData();
                return wart.getState().equals((Object)NetherWartsState.RIPE);
            }
            if (block.getState().getData() instanceof CocoaPlant) {
                CocoaPlant cocoaPlant = (CocoaPlant)block.getState().getData();
                return cocoaPlant.getSize().equals((Object)CocoaPlant.CocoaPlantSize.LARGE);
            }
        }
        return false;
    }

    public static int getGrowthStage(Block block) {
        if (XMaterial.isNewVersion() && block.getBlockData() instanceof Ageable) {
            Ageable crop = (Ageable)block.getBlockData();
            return crop.getAge();
        }
        return 0;
    }

    public static boolean isCarrot(Material material) {
        return material == Material.CARROT || material.name().equals("CARROTS");
    }

    public static boolean isPotato(Material material) {
        return material == Material.POTATO || material.name().equals("POTATOES");
    }

    public static boolean isBeetroot(Material material) {
        return material == Material.BEETROOT || material.name().equals("BEETROOTS") || material.name().equals("BEETROOT_BLOCK");
    }

    public static boolean isWheat(Material material) {
        return material == Material.WHEAT || material.name().equals("CROPS");
    }

    public static boolean isNetherWart(Material material) {
        return material.name().equals("NETHER_WART") || material.name().equals("NETHER_WARTS") || material.name().equals("NETHER_STALK");
    }

    public static boolean isReplenishable(Material material) {
        return BlockUtil.isWheat(material) || BlockUtil.isCarrot(material) || BlockUtil.isPotato(material) || BlockUtil.isBeetroot(material) || BlockUtil.isNetherWart(material);
    }
}

