/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.ui;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.lang.ActionBarMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.util.math.BigNumber;
import com.archyx.aureliumskills.util.math.RomanNumber;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillBossBar
implements Listener {
    private final Map<Player, Map<Skill, BossBar>> bossBars;
    private final Map<Player, Map<Skill, Integer>> currentActions;
    private final Map<Player, Map<Skill, Integer>> checkCurrentActions;
    private final Map<Player, BossBar> singleBossBars;
    private final Map<Player, Integer> singleCurrentActions;
    private final Map<Player, Integer> singleCheckCurrentActions;
    private String mode;
    private int stayTime;
    private Map<Skill, BarColor> colors;
    private Map<Skill, BarStyle> styles;
    private final NumberFormat nf = new DecimalFormat("#.#");
    private final AureliumSkills plugin;

    public SkillBossBar(AureliumSkills plugin) {
        this.bossBars = new HashMap<Player, Map<Skill, BossBar>>();
        this.currentActions = new HashMap<Player, Map<Skill, Integer>>();
        this.plugin = plugin;
        this.singleBossBars = new HashMap<Player, BossBar>();
        this.singleCurrentActions = new HashMap<Player, Integer>();
        this.checkCurrentActions = new HashMap<Player, Map<Skill, Integer>>();
        this.singleCheckCurrentActions = new HashMap<Player, Integer>();
    }

    public void loadOptions() {
        this.mode = OptionL.getString(Option.BOSS_BAR_MODE);
        this.stayTime = OptionL.getInt(Option.BOSS_BAR_STAY_TIME);
        this.colors = new HashMap<Skill, BarColor>();
        this.styles = new HashMap<Skill, BarStyle>();
        for (String string : OptionL.getList(Option.BOSS_BAR_FORMAT)) {
            String[] splitEntry = string.split(" ");
            BarColor color = BarColor.GREEN;
            BarStyle style = BarStyle.SOLID;
            Skill skill = this.plugin.getSkillRegistry().getSkill(splitEntry[0].toUpperCase());
            if (skill == null) {
                this.plugin.getLogger().warning("Error loading boss bar format in config.yml: " + splitEntry[0] + " is not a valid Skill");
                skill = Skills.FARMING;
            }
            if (splitEntry.length > 1) {
                try {
                    color = BarColor.valueOf((String)splitEntry[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Error loading boss bar format in config.yml: " + splitEntry[0] + " is not a valid BarColor");
                }
                if (splitEntry.length > 2) {
                    try {
                        style = BarStyle.valueOf((String)splitEntry[2].toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Error loading boss bar format in config.yml: " + splitEntry[0] + " is not a valid BarStyle");
                    }
                }
            }
            this.colors.put(skill, color);
            this.styles.put(skill, style);
        }
        for (Map.Entry entry : this.singleBossBars.entrySet()) {
            ((BossBar)entry.getValue()).setVisible(false);
            ((BossBar)entry.getValue()).removeAll();
        }
        for (Map.Entry entry : this.bossBars.entrySet()) {
            Map bossBars = (Map)entry.getValue();
            for (Map.Entry bossBarEntry : bossBars.entrySet()) {
                ((BossBar)bossBarEntry.getValue()).setVisible(false);
                ((BossBar)bossBarEntry.getValue()).removeAll();
            }
        }
        this.bossBars.clear();
        this.singleBossBars.clear();
    }

    public void sendBossBar(Player player, Skill skill, double currentXp, double levelXp, int level, boolean maxed) {
        double progress;
        BossBar bossBar;
        if (maxed && !OptionL.getBoolean(Option.BOSS_BAR_DISPLAY_MAXED)) {
            return;
        }
        Locale locale = this.plugin.getLang().getLocale(player);
        BarColor color = this.getColor(skill);
        BarStyle style = this.getStyle(skill);
        if (this.mode.equals("single")) {
            bossBar = this.singleBossBars.get(player);
        } else {
            if (!this.bossBars.containsKey(player)) {
                this.bossBars.put(player, new HashMap());
            }
            bossBar = this.bossBars.get(player).get(skill);
        }
        if (bossBar == null) {
            bossBar = !maxed ? (!OptionL.getBoolean(Option.BOSS_BAR_ROUND_XP) ? Bukkit.createBossBar((String)TextUtil.replace(Lang.getMessage(ActionBarMessage.BOSS_BAR_XP, locale), "{skill}", skill.getDisplayName(locale), "{level}", RomanNumber.toRoman(level), "{current_xp}", this.nf.format(currentXp), "{level_xp}", BigNumber.withSuffix((long)levelXp)), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]) : Bukkit.createBossBar((String)TextUtil.replace(Lang.getMessage(ActionBarMessage.BOSS_BAR_XP, locale), "{skill}", skill.getDisplayName(locale), "{level}", RomanNumber.toRoman(level), "{current_xp}", String.valueOf((int)currentXp), "{level_xp}", BigNumber.withSuffix((long)levelXp)), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0])) : Bukkit.createBossBar((String)TextUtil.replace(Lang.getMessage(ActionBarMessage.BOSS_BAR_MAXED, locale), "{skill}", skill.getDisplayName(locale), "{level}", RomanNumber.toRoman(level)), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
            progress = currentXp / levelXp;
            if (progress <= 1.0 && progress >= 0.0) {
                bossBar.setProgress(currentXp / levelXp);
            } else {
                bossBar.setProgress(1.0);
            }
            bossBar.addPlayer(player);
            if (this.mode.equals("single")) {
                this.singleBossBars.put(player, bossBar);
            } else {
                this.bossBars.get(player).put(skill, bossBar);
            }
        } else {
            if (!maxed) {
                if (!OptionL.getBoolean(Option.BOSS_BAR_ROUND_XP)) {
                    bossBar.setTitle(TextUtil.replace(Lang.getMessage(ActionBarMessage.BOSS_BAR_XP, locale), "{skill}", skill.getDisplayName(locale), "{level}", RomanNumber.toRoman(level), "{current_xp}", this.nf.format(currentXp), "{level_xp}", BigNumber.withSuffix((long)levelXp)));
                } else {
                    bossBar.setTitle(TextUtil.replace(Lang.getMessage(ActionBarMessage.BOSS_BAR_XP, locale), "{skill}", skill.getDisplayName(locale), "{level}", RomanNumber.toRoman(level), "{current_xp}", String.valueOf((int)currentXp), "{level_xp}", BigNumber.withSuffix((long)levelXp)));
                }
            } else {
                bossBar.setTitle(TextUtil.replace(Lang.getMessage(ActionBarMessage.BOSS_BAR_MAXED, locale), "{level}", RomanNumber.toRoman(level), "{skill}", skill.getDisplayName(locale)));
            }
            progress = currentXp / levelXp;
            if (progress <= 1.0 && progress >= 0.0) {
                bossBar.setProgress(currentXp / levelXp);
            } else {
                bossBar.setProgress(1.0);
            }
            bossBar.setVisible(true);
        }
        if (this.mode.equals("single")) {
            Integer currentAction = this.singleCurrentActions.get(player);
            if (currentAction != null) {
                this.singleCurrentActions.put(player, currentAction + 1);
            } else {
                this.singleCurrentActions.put(player, 0);
            }
        } else {
            Integer currentAction;
            if (!this.currentActions.containsKey(player)) {
                this.currentActions.put(player, new HashMap());
            }
            if ((currentAction = this.currentActions.get(player).get(skill)) != null) {
                this.currentActions.get(player).put(skill, currentAction + 1);
            } else {
                this.currentActions.get(player).put(skill, 0);
            }
        }
        this.scheduleHide(player, skill, bossBar);
    }

    public void incrementAction(Player player, Skill skill) {
        if (!this.singleCheckCurrentActions.containsKey(player)) {
            this.singleCheckCurrentActions.put(player, 0);
        }
        if (!this.checkCurrentActions.containsKey(player)) {
            this.checkCurrentActions.put(player, new HashMap());
        }
        if (this.mode.equals("single")) {
            this.singleCheckCurrentActions.put(player, this.singleCheckCurrentActions.get(player) + 1);
        } else {
            Integer currentAction = this.checkCurrentActions.get(player).get(skill);
            if (currentAction != null) {
                this.checkCurrentActions.get(player).put(skill, currentAction + 1);
            } else {
                this.checkCurrentActions.get(player).put(skill, 0);
            }
        }
    }

    private void scheduleHide(final Player player, final Skill skill, final BossBar bossBar) {
        if (this.mode.equals("single")) {
            final int currentAction = this.singleCurrentActions.get(player);
            new BukkitRunnable(){

                public void run() {
                    if (SkillBossBar.this.mode.equals("single") && currentAction == (Integer)SkillBossBar.this.singleCurrentActions.get(player)) {
                        bossBar.setVisible(false);
                        SkillBossBar.this.singleCheckCurrentActions.remove(player);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)this.stayTime);
        } else {
            Map<Skill, Integer> multiCurrentActions = this.currentActions.get(player);
            if (multiCurrentActions != null) {
                final int currentAction = multiCurrentActions.get(skill);
                new BukkitRunnable(){

                    public void run() {
                        Map multiCurrentActions;
                        if (!SkillBossBar.this.mode.equals("single") && (multiCurrentActions = (Map)SkillBossBar.this.currentActions.get(player)) != null && currentAction == (Integer)multiCurrentActions.get(skill)) {
                            bossBar.setVisible(false);
                            SkillBossBar.this.checkCurrentActions.remove(player);
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, (long)this.stayTime);
            }
        }
    }

    private BarColor getColor(Skill skill) {
        BarColor color = this.colors.get(skill);
        if (color == null) {
            color = BarColor.GREEN;
        }
        return color;
    }

    private BarStyle getStyle(Skill skill) {
        BarStyle style = this.styles.get(skill);
        if (style == null) {
            style = BarStyle.SOLID;
        }
        return style;
    }

    public int getCurrentAction(Player player, Skill skill) {
        if (this.mode.equals("single")) {
            return this.singleCheckCurrentActions.get(player);
        }
        Map<Skill, Integer> multiCurrentActions = this.checkCurrentActions.get(player);
        if (multiCurrentActions != null) {
            return multiCurrentActions.get(skill);
        }
        return -1;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.bossBars.remove(player);
        this.currentActions.remove(player);
        this.singleBossBars.remove(player);
        this.singleCurrentActions.remove(player);
        this.checkCurrentActions.remove(player);
        this.singleCheckCurrentActions.remove(player);
    }
}

