/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.ui;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ui.ActionBar;
import com.archyx.aureliumskills.util.version.VersionUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ActionBarCompatHandler {
    private final AureliumSkills plugin;
    private final ActionBar actionBar;
    private static final int PAUSE_TICKS = 50;

    public ActionBarCompatHandler(AureliumSkills plugin) {
        this.plugin = plugin;
        this.actionBar = plugin.getActionBar();
    }

    public void registerListeners() {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        if (VersionUtils.isAtLeastVersion(17)) {
            this.registerNewListener(manager);
        } else {
            this.registerLegacyListener(manager);
        }
        this.registerChatListener(manager);
    }

    private void registerNewListener(ProtocolManager manager) {
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.SET_ACTION_BAR_TEXT}){

            public void onPacketSending(PacketEvent event) {
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                if (packet.getMeta("AureliumSkills").isPresent()) {
                    return;
                }
                ActionBarCompatHandler.this.actionBar.setPaused(player, 50);
            }
        });
    }

    private void registerLegacyListener(ProtocolManager manager) {
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.TITLE}){

            public void onPacketSending(PacketEvent event) {
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                if (packet.getEnumModifier(EnumWrappers.TitleAction.class, 0).read(0) != EnumWrappers.TitleAction.ACTIONBAR) {
                    return;
                }
                if (packet.getMeta("AureliumSkills").isPresent()) {
                    return;
                }
                ActionBarCompatHandler.this.actionBar.setPaused(player, 50);
            }
        });
    }

    private void registerChatListener(ProtocolManager manager) {
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.CHAT}){

            public void onPacketSending(PacketEvent event) {
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                if (packet.getChatTypes().read(0) != EnumWrappers.ChatType.GAME_INFO) {
                    return;
                }
                ActionBarCompatHandler.this.actionBar.setPaused(player, 50);
            }
        });
    }
}

