/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.ui;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.ActionBarMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.math.BigNumber;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.archyx.aureliumskills.util.version.VersionUtils;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Jukebox;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Bed;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBar
implements Listener {
    private final AureliumSkills plugin;
    private final HashSet<Player> isPaused = new HashSet();
    private final HashSet<Player> isGainingXp = new HashSet();
    private final HashMap<Player, Integer> timer = new HashMap();
    private final HashMap<Player, Integer> currentAction = new HashMap();
    private final HashSet<UUID> actionBarDisabled = new HashSet();

    public ActionBar(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public void startUpdateActionBar() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (OptionL.getBoolean(Option.ACTION_BAR_ENABLED) && OptionL.getBoolean(Option.ACTION_BAR_IDLE)) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    PlayerData playerData;
                    if (this.actionBarDisabled.contains(player.getUniqueId()) || this.plugin.getWorldManager().isDisabledWorld(player.getWorld())) continue;
                    if (!this.currentAction.containsKey(player)) {
                        this.currentAction.put(player, 0);
                    }
                    if (this.isGainingXp.contains(player) || this.isPaused.contains(player) || (playerData = this.plugin.getPlayerManager().getPlayerData(player)) == null) continue;
                    Locale locale = playerData.getLocale();
                    this.sendActionBar(player, TextUtil.replace(Lang.getMessage(ActionBarMessage.IDLE, locale), "{hp}", this.getHp(player), "{max_hp}", this.getMaxHp(player), "{mana}", this.getMana(playerData), "{max_mana}", this.getMaxMana(playerData)));
                }
            }
        }, 0L, (long)OptionL.getInt(Option.ACTION_BAR_UPDATE_PERIOD));
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (OptionL.getBoolean(Option.ACTION_BAR_ENABLED)) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Integer time = this.timer.get(player);
                    if (time != null) {
                        if (time == 0) continue;
                        this.timer.put(player, time - 1);
                        continue;
                    }
                    this.timer.put(player, 0);
                }
            }
        }, 0L, 2L);
    }

    public void sendXpActionBar(final Player player, final Skill skill, final double xpAmount) {
        PlayerData playerData;
        if (OptionL.getBoolean(Option.ACTION_BAR_ENABLED) && !this.actionBarDisabled.contains(player.getUniqueId()) && (playerData = this.plugin.getPlayerManager().getPlayerData(player)) != null) {
            boolean notMaxed;
            final Locale locale = playerData.getLocale();
            boolean bl = notMaxed = this.plugin.getLeveler().getXpRequirements().getListSize(skill) > playerData.getSkillLevel(skill) - 1 && playerData.getSkillLevel(skill) < OptionL.getMaxLevel(skill);
            if (notMaxed && !OptionL.getBoolean(Option.ACTION_BAR_XP)) {
                return;
            }
            if (!notMaxed && !OptionL.getBoolean(Option.ACTION_BAR_MAXED)) {
                return;
            }
            if (this.isPaused.contains(player)) {
                return;
            }
            this.isGainingXp.add(player);
            this.timer.put(player, 20);
            if (!this.currentAction.containsKey(player)) {
                this.currentAction.put(player, 0);
            }
            this.currentAction.put(player, this.currentAction.get(player) + 1);
            final int thisAction = this.currentAction.get(player);
            new BukkitRunnable(){

                public void run() {
                    if (ActionBar.this.isGainingXp.contains(player)) {
                        Integer actionBarCurrentAction = (Integer)ActionBar.this.currentAction.get(player);
                        if (actionBarCurrentAction != null) {
                            if (thisAction == actionBarCurrentAction) {
                                boolean notMaxed;
                                boolean bl = notMaxed = ActionBar.this.plugin.getLeveler().getXpRequirements().getListSize(skill) > playerData.getSkillLevel(skill) - 1 && playerData.getSkillLevel(skill) < OptionL.getMaxLevel(skill);
                                if (notMaxed) {
                                    if (OptionL.getBoolean(Option.ACTION_BAR_XP)) {
                                        if (xpAmount >= 0.0) {
                                            if (!OptionL.getBoolean(Option.ACTION_BAR_ROUND_XP)) {
                                                ActionBar.this.sendActionBar(player, TextUtil.replace(TextUtil.replace(Lang.getMessage(ActionBarMessage.XP, locale), "{hp}", ActionBar.this.getHp(player), "{max_hp}", ActionBar.this.getMaxHp(player), "{xp_gained}", NumberUtil.format1(xpAmount), "{skill}", skill.getDisplayName(locale), "{current_xp}", NumberUtil.format1(playerData.getSkillXp(skill))), "{level_xp}", BigNumber.withSuffix(ActionBar.this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData.getSkillLevel(skill) + 1)), "{mana}", ActionBar.this.getMana(playerData), "{max_mana}", ActionBar.this.getMaxMana(playerData)));
                                            } else {
                                                ActionBar.this.sendActionBar(player, TextUtil.replace(TextUtil.replace(Lang.getMessage(ActionBarMessage.XP, locale), "{hp}", ActionBar.this.getHp(player), "{max_hp}", ActionBar.this.getMaxHp(player), "{xp_gained}", NumberUtil.format1(xpAmount), "{skill}", skill.getDisplayName(locale), "{current_xp}", String.valueOf((int)playerData.getSkillXp(skill))), "{level_xp}", BigNumber.withSuffix(ActionBar.this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData.getSkillLevel(skill) + 1)), "{mana}", ActionBar.this.getMana(playerData), "{max_mana}", ActionBar.this.getMaxMana(playerData)));
                                            }
                                        } else if (!OptionL.getBoolean(Option.ACTION_BAR_ROUND_XP)) {
                                            ActionBar.this.sendActionBar(player, TextUtil.replace(TextUtil.replace(Lang.getMessage(ActionBarMessage.XP_REMOVED, locale), "{hp}", ActionBar.this.getHp(player), "{max_hp}", ActionBar.this.getMaxHp(player), "{xp_removed}", NumberUtil.format1(xpAmount), "{skill}", skill.getDisplayName(locale), "{current_xp}", NumberUtil.format1(playerData.getSkillXp(skill))), "{level_xp}", BigNumber.withSuffix(ActionBar.this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData.getSkillLevel(skill) + 1)), "{mana}", ActionBar.this.getMana(playerData), "{max_mana}", ActionBar.this.getMaxMana(playerData)));
                                        } else {
                                            ActionBar.this.sendActionBar(player, TextUtil.replace(TextUtil.replace(Lang.getMessage(ActionBarMessage.XP, locale), "{hp}", ActionBar.this.getHp(player), "{max_hp}", ActionBar.this.getMaxHp(player), "{xp_gained}", NumberUtil.format1(xpAmount), "{skill}", skill.getDisplayName(locale), "{current_xp}", String.valueOf((int)playerData.getSkillXp(skill))), "{level_xp}", BigNumber.withSuffix(ActionBar.this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData.getSkillLevel(skill) + 1)), "{mana}", ActionBar.this.getMana(playerData), "{max_mana}", ActionBar.this.getMaxMana(playerData)));
                                        }
                                    }
                                } else if (OptionL.getBoolean(Option.ACTION_BAR_MAXED)) {
                                    if (xpAmount >= 0.0) {
                                        ActionBar.this.sendActionBar(player, TextUtil.replace(Lang.getMessage(ActionBarMessage.MAXED, locale), "{hp}", ActionBar.this.getHp(player), "{max_hp}", ActionBar.this.getMaxHp(player), "{xp_gained}", NumberUtil.format1(xpAmount), "{skill}", skill.getDisplayName(locale), "{mana}", ActionBar.this.getMana(playerData), "{max_mana}", ActionBar.this.getMaxMana(playerData)));
                                    } else {
                                        ActionBar.this.sendActionBar(player, TextUtil.replace(Lang.getMessage(ActionBarMessage.MAXED_REMOVED, locale), "{hp}", ActionBar.this.getHp(player), "{max_hp}", ActionBar.this.getMaxHp(player), "{xp_removed}", NumberUtil.format1(xpAmount), "{skill}", skill.getDisplayName(locale), "{mana}", ActionBar.this.getMana(playerData), "{max_mana}", ActionBar.this.getMaxMana(playerData)));
                                    }
                                }
                            } else {
                                this.cancel();
                            }
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, (long)OptionL.getInt(Option.ACTION_BAR_UPDATE_PERIOD));
            new BukkitRunnable(){

                public void run() {
                    Integer timerNum = (Integer)ActionBar.this.timer.get(player);
                    if (timerNum != null && timerNum.equals(0)) {
                        ActionBar.this.isGainingXp.remove(player);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 41L);
        }
    }

    public void sendAbilityActionBar(Player player, String message) {
        if (!this.actionBarDisabled.contains(player.getUniqueId())) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            this.sendActionBar(player, TextUtil.replace(Lang.getMessage(ActionBarMessage.ABILITY, playerData.getLocale()), "{hp}", this.getHp(player), "{max_hp}", this.getMaxHp(player), "{mana}", this.getMana(playerData), "{max_mana}", this.getMaxMana(playerData), "{message}", message));
            this.setPaused(player, 40);
        }
    }

    private String getHp(Player player) {
        return String.valueOf(Math.round(player.getHealth() * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING)));
    }

    private String getMaxHp(Player player) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute != null) {
            return String.valueOf(Math.round(attribute.getValue() * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING)));
        }
        return "";
    }

    private String getMana(PlayerData playerData) {
        return String.valueOf(Math.round(playerData.getMana()));
    }

    private String getMaxMana(PlayerData playerData) {
        return String.valueOf(Math.round(playerData.getMaxMana()));
    }

    private void sendActionBar(Player player, String message) {
        if (OptionL.getBoolean(Option.ACTION_BAR_PLACEHOLDER_API) && this.plugin.isPlaceholderAPIEnabled()) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        if (this.plugin.isProtocolLibEnabled()) {
            if (VersionUtils.isAtLeastVersion(17)) {
                this.plugin.getProtocolLibSupport().sendNewActionBar(player, message);
            } else {
                this.plugin.getProtocolLibSupport().sendLegacyActionBar(player, message);
            }
        } else {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
    }

    public void resetActionBars() {
        this.isGainingXp.clear();
        this.timer.clear();
        this.currentAction.clear();
        this.isPaused.clear();
    }

    public void resetActionBar(Player player) {
        this.isGainingXp.remove(player);
        this.timer.remove(player);
        this.currentAction.remove(player);
        this.isPaused.remove(player);
    }

    public HashSet<UUID> getActionBarDisabled() {
        return this.actionBarDisabled;
    }

    public void setPaused(final Player player, int ticks) {
        this.isPaused.add(player);
        Integer action = this.currentAction.get(player);
        if (action != null) {
            this.currentAction.put(player, action + 1);
        } else {
            this.currentAction.put(player, 0);
        }
        final int thisAction = this.currentAction.get(player);
        new BukkitRunnable(){

            public void run() {
                Integer actionBarCurrentAction = (Integer)ActionBar.this.currentAction.get(player);
                if (actionBarCurrentAction != null && thisAction == actionBarCurrentAction) {
                    ActionBar.this.isPaused.remove(player);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)ticks);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (block.getType().name().equals("BED_BLOCK") || block.getType().name().contains("_BED")) {
                org.bukkit.block.data.type.Bed bed;
                Block other = block;
                if (XMaterial.isNewVersion()) {
                    if (block.getBlockData() instanceof org.bukkit.block.data.type.Bed) {
                        bed = (org.bukkit.block.data.type.Bed)block.getBlockData();
                        other = bed.getPart() == Bed.Part.FOOT ? block.getRelative(bed.getFacing()) : block.getRelative(bed.getFacing().getOppositeFace());
                    }
                } else if (block.getState().getData() instanceof Bed) {
                    bed = (Bed)block.getState().getData();
                    other = bed.isHeadOfBed() ? block.getRelative(bed.getFacing().getOppositeFace()) : block.getRelative(bed.getFacing());
                }
                Location mainLoc = block.getLocation().add(0.5, 0.0, 0.5);
                Location otherLoc = other.getLocation().add(0.5, 0.0, 0.5);
                Location center = mainLoc.distanceSquared(player.getLocation()) < otherLoc.distanceSquared(player.getLocation()) ? mainLoc : otherLoc;
                if (player.getLocation().distanceSquared(center) >= 9.0) {
                    this.setPaused(player, 40);
                } else if (player.getWorld().getTime() >= 12541L && player.getWorld().getTime() <= 23458L) {
                    for (Entity entity : player.getWorld().getNearbyEntities(center, 8.0, 5.0, 8.0)) {
                        EntityType type = entity.getType();
                        if (type == EntityType.BLAZE || type == EntityType.CREEPER || type.name().equals("DROWNED") || type == EntityType.ENDERMITE || type == EntityType.EVOKER || type == EntityType.GIANT || type == EntityType.GUARDIAN || type == EntityType.ELDER_GUARDIAN || type == EntityType.ILLUSIONER || type.name().equals("PIGLIN_BRUTE") || type.name().equals("PILLAGER") || type.name().equals("PHANTOM") || type.name().equals("RAVAGER") || type == EntityType.SILVERFISH || type == EntityType.SKELETON || type.name().equals("STRAY") || type == EntityType.WITHER_SKELETON || type == EntityType.SPIDER || type == EntityType.CAVE_SPIDER || type == EntityType.VEX || type == EntityType.VINDICATOR || type == EntityType.WITCH || type == EntityType.WITHER || type.name().equals("ZOGLIN") || type == EntityType.ZOMBIE || type == EntityType.ZOMBIE_VILLAGER || type.name().equals("HUSK")) {
                            this.setPaused(player, 40);
                        } else if (type == EntityType.ENDERMAN && entity instanceof Enderman) {
                            Enderman enderman = (Enderman)entity;
                            if (enderman.getTarget() == null) continue;
                            this.setPaused(player, 40);
                        } else {
                            PigZombie pigZombie;
                            if (!type.name().equals("ZOMBIFIED_PIGLIN") && !type.name().equals("PIG_ZOMBIE") || !(entity instanceof PigZombie) || !(pigZombie = (PigZombie)entity).isAngry()) continue;
                            this.setPaused(player, 40);
                        }
                        break;
                    }
                } else {
                    this.setPaused(player, 40);
                }
            } else if (block.getType() == Material.JUKEBOX) {
                ItemStack item = event.getItem();
                if (item != null && (item.getType().name().contains("MUSIC_DISC") || item.getType().name().contains("RECORD"))) {
                    org.bukkit.block.data.type.Jukebox jukebox;
                    boolean isPlace = false;
                    if (XMaterial.isNewVersion()) {
                        if (block.getBlockData() instanceof org.bukkit.block.data.type.Jukebox && !(jukebox = (org.bukkit.block.data.type.Jukebox)block.getBlockData()).hasRecord()) {
                            isPlace = true;
                        }
                    } else if (block.getState() instanceof Jukebox && !(jukebox = (Jukebox)block.getState()).isPlaying()) {
                        isPlace = true;
                    }
                    if (isPlace) {
                        for (Entity entity : block.getWorld().getNearbyEntities(block.getLocation(), 65.0, 65.0, 65.0)) {
                            if (!(entity instanceof Player) || !(entity.getLocation().distanceSquared(block.getLocation()) <= 4225.0)) continue;
                            Player listener = (Player)entity;
                            this.setPaused(listener, 40);
                        }
                    }
                }
            } else {
                ItemStack item = event.getItem();
                if (item != null && item.getType().isBlock() && block.getY() == block.getWorld().getMaxHeight() - 1 && event.getBlockFace() == BlockFace.UP) {
                    this.setPaused(player, 40);
                }
            }
        }
    }
}

