/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.support;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.support.WorldGuardFlags;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class WorldGuardSupport {
    private RegionContainer container;
    private final AureliumSkills plugin;
    private List<String> blockedRegions;
    private List<String> blockedCheckBlockReplaceRegions;

    public WorldGuardSupport(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public void loadRegions() {
        try {
            this.container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            FileConfiguration config = this.plugin.getConfig();
            this.blockedRegions = new LinkedList<String>();
            this.blockedRegions.addAll(config.getStringList("blocked-regions"));
            this.blockedCheckBlockReplaceRegions = new LinkedList<String>();
            this.blockedCheckBlockReplaceRegions.addAll(config.getStringList("blocked-check-block-replace-regions"));
            Bukkit.getLogger().info("[AureliumSkills] WorldGuard Support Enabled!");
        }
        catch (Exception e) {
            this.plugin.setWorldGuardEnabled(false);
            Bukkit.getLogger().warning("[AureliumSkills] WorldGuard support failed to load, disabling World Guard support!");
        }
    }

    public boolean isInBlockedRegion(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        RegionManager regions = this.container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(BukkitAdapter.adapt((Location)location).toVector().toBlockPoint());
        for (ProtectedRegion region : set) {
            if (!this.blockedRegions.contains(region.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean blockedByFlag(Location location, Player player, WorldGuardFlags.FlagKey flagKey) {
        WorldGuardFlags worldGuardFlags = this.plugin.getWorldGuardFlags();
        if (worldGuardFlags == null) {
            return false;
        }
        StateFlag flag = worldGuardFlags.getStateFlag(flagKey);
        if (flag == null) {
            return false;
        }
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        RegionManager regions = this.container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(BukkitAdapter.adapt((Location)location).toVector().toBlockPoint());
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        StateFlag.State state = set.queryState((RegionAssociable)localPlayer, new StateFlag[]{flag});
        return state == StateFlag.State.DENY;
    }

    public boolean isInBlockedCheckRegion(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        RegionManager regions = this.container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(BukkitAdapter.adapt((Location)location).toVector().toBlockPoint());
        for (ProtectedRegion region : set) {
            if (!this.blockedCheckBlockReplaceRegions.contains(region.getId())) continue;
            return true;
        }
        return false;
    }
}

