/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.support;

import com.archyx.aureliumskills.util.text.TextUtil;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;

public class WorldGuardFlags {
    private final Map<FlagKey, StateFlag> stateFlags = new HashMap<FlagKey, StateFlag>();

    @Nullable
    public StateFlag getStateFlag(FlagKey flagKey) {
        return this.stateFlags.get((Object)flagKey);
    }

    public void register() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        for (FlagKey flagKey : FlagKey.values()) {
            Object def = flagKey.getDefault();
            if (!(def instanceof Boolean)) continue;
            String flagName = "aureliumskills-" + TextUtil.replace(flagKey.toString().toLowerCase(Locale.ROOT), "_", "-");
            try {
                StateFlag stateFlag = new StateFlag(flagName, ((Boolean)def).booleanValue());
                registry.register((Flag)stateFlag);
                this.stateFlags.put(flagKey, stateFlag);
            }
            catch (FlagConflictException e) {
                Flag existing = registry.get(flagName);
                if (existing instanceof StateFlag) {
                    this.stateFlags.put(flagKey, (StateFlag)existing);
                    continue;
                }
                Bukkit.getLogger().warning("Could not register flag " + flagName);
                e.printStackTrace();
            }
        }
    }

    public static enum FlagKey {
        XP_GAIN(true);

        private final Object def;

        private FlagKey(Object def) {
            this.def = def;
        }

        public Object getDefault() {
            return this.def;
        }
    }
}

