/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.support;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.leaderboard.SkillValue;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.util.math.BigNumber;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.math.RomanNumber;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;

public class PlaceholderSupport
extends PlaceholderExpansion {
    private final AureliumSkills plugin;
    private final String[] xpIdentifiers = new String[]{"xp_required_formatted_", "xp_required_", "xp_progress_int_", "xp_progress_1_", "xp_progress_", "xp_int_", "xp_formatted_", "xp_"};

    public PlaceholderSupport(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getIdentifier() {
        return "aureliumskills";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        PlayerData playerData;
        PlayerData playerData2;
        PlayerData playerData3;
        PlayerData playerData4;
        PlayerData playerData5;
        PlayerData playerData6;
        if (player == null) {
            return "";
        }
        if (identifier.equals("power") && (playerData6 = this.plugin.getPlayerManager().getPlayerData(player)) != null) {
            return String.valueOf(playerData6.getPowerLevel());
        }
        if (identifier.equals("hp")) {
            return String.valueOf(Math.round(player.getHealth() * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING)));
        }
        if (identifier.equals("hp_1")) {
            return NumberUtil.format1(player.getHealth() * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING));
        }
        if (identifier.equals("hp_max")) {
            AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attributeInstance != null) {
                return String.valueOf(Math.round(attributeInstance.getValue() * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING)));
            }
            return "";
        }
        if (identifier.equals("hp_2")) {
            return NumberUtil.format2(player.getHealth() * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING));
        }
        if (identifier.equals("hp_percent")) {
            AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attributeInstance != null) {
                return String.valueOf(Math.round(player.getHealth() / attributeInstance.getValue()));
            }
            return "";
        }
        if (identifier.equals("mana") && (playerData5 = this.plugin.getPlayerManager().getPlayerData(player)) != null) {
            return String.valueOf(playerData5.getMana());
        }
        if (identifier.equals("mana_int") && (playerData4 = this.plugin.getPlayerManager().getPlayerData(player)) != null) {
            return String.valueOf(Math.round(playerData4.getMana()));
        }
        if (identifier.equals("mana_max") && (playerData3 = this.plugin.getPlayerManager().getPlayerData(player)) != null) {
            return String.valueOf(playerData3.getMaxMana());
        }
        if (identifier.equals("mana_max_int") && (playerData2 = this.plugin.getPlayerManager().getPlayerData(player)) != null) {
            return String.valueOf(Math.round(playerData2.getMaxMana()));
        }
        for (Stat stat : this.plugin.getStatRegistry().getStats()) {
            if (identifier.equals(stat.name().toLowerCase(Locale.ENGLISH))) {
                playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) continue;
                return String.valueOf(playerData.getStatLevel(stat));
            }
            if (!identifier.equals(stat.name().toLowerCase(Locale.ROOT) + "_int") || (playerData = this.plugin.getPlayerManager().getPlayerData(player)) == null) continue;
            return String.valueOf(Math.round(playerData.getStatLevel(stat)));
        }
        for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            if (identifier.equals(skill.name().toLowerCase(Locale.ENGLISH))) {
                playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) continue;
                return String.valueOf(playerData.getSkillLevel(skill));
            }
            if (!identifier.equals(skill.name().toLowerCase(Locale.ENGLISH) + "_roman") || (playerData = this.plugin.getPlayerManager().getPlayerData(player)) == null) continue;
            return RomanNumber.toRoman(playerData.getSkillLevel(skill));
        }
        if (identifier.startsWith("lb_")) {
            String string = TextUtil.replace(identifier, "lb_", "");
            if (string.startsWith("power_")) {
                int valuePlace;
                int place = NumberUtils.toInt((String)TextUtil.replace(string, "power_", ""));
                if (place > 0) {
                    List<SkillValue> list = this.plugin.getLeaderboardManager().getPowerLeaderboard(place, 1);
                    if (list.size() > 0) {
                        SkillValue skillValue = list.get(0);
                        String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                        return (name != null ? name : "?") + " - " + skillValue.getLevel();
                    }
                    return "";
                }
                if (identifier.endsWith("name")) {
                    int namePlace = NumberUtils.toInt((String)TextUtil.replace(string, "power_", "", "_name", ""));
                    if (namePlace > 0) {
                        List<SkillValue> list = this.plugin.getLeaderboardManager().getPowerLeaderboard(namePlace, 1);
                        if (list.size() > 0) {
                            SkillValue skillValue = list.get(0);
                            String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                            return name != null ? name : "?";
                        }
                        return "";
                    }
                } else if (identifier.endsWith("value") && (valuePlace = NumberUtils.toInt((String)TextUtil.replace(string, "power_", "", "_value", ""))) > 0) {
                    List<SkillValue> list = this.plugin.getLeaderboardManager().getPowerLeaderboard(valuePlace, 1);
                    if (list.size() > 0) {
                        SkillValue playerSkill = list.get(0);
                        return String.valueOf(playerSkill.getLevel());
                    }
                    return "";
                }
            } else {
                for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
                    int valuePlace;
                    if (!string.startsWith(skill.name().toLowerCase(Locale.ENGLISH) + "_")) continue;
                    int place = NumberUtils.toInt((String)TextUtil.replace(string, skill.name().toLowerCase(Locale.ENGLISH) + "_", ""));
                    if (place > 0) {
                        List<SkillValue> list = this.plugin.getLeaderboardManager().getLeaderboard(skill, 1, 1);
                        if (list.size() > 0) {
                            SkillValue skillValue = list.get(0);
                            String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                            return (name != null ? name : "?") + " - " + skillValue.getLevel();
                        }
                        return "";
                    }
                    if (identifier.endsWith("name")) {
                        int namePlace = NumberUtils.toInt((String)TextUtil.replace(string, skill.name().toLowerCase(Locale.ENGLISH) + "_", "", "_name", ""));
                        if (namePlace <= 0) continue;
                        List<SkillValue> list = this.plugin.getLeaderboardManager().getLeaderboard(skill, namePlace, 1);
                        if (list.size() > 0) {
                            SkillValue skillValue = list.get(0);
                            String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                            return name != null ? name : "?";
                        }
                        return "";
                    }
                    if (!identifier.endsWith("value") || (valuePlace = NumberUtils.toInt((String)TextUtil.replace(string, skill.name().toLowerCase(Locale.ENGLISH) + "_", "", "_value", ""))) <= 0) continue;
                    List<SkillValue> list = this.plugin.getLeaderboardManager().getLeaderboard(skill, valuePlace, 1);
                    if (list.size() > 0) {
                        SkillValue skillValue = list.get(0);
                        return String.valueOf(skillValue.getLevel());
                    }
                    return "";
                }
            }
        }
        if (identifier.equals("rank")) {
            return String.valueOf(this.plugin.getLeaderboardManager().getPowerRank(player.getUniqueId()));
        }
        if (identifier.startsWith("rank_")) {
            String string = TextUtil.replace(identifier, "rank_", "");
            Skill skill = this.plugin.getSkillRegistry().getSkill(string);
            if (skill != null) {
                return String.valueOf(this.plugin.getLeaderboardManager().getSkillRank(skill, player.getUniqueId()));
            }
        }
        for (String id : this.xpIdentifiers) {
            PlayerData playerData32;
            if (!identifier.startsWith(id)) continue;
            String skillName2 = TextUtil.replace(identifier, id, "");
            Skill skill = this.plugin.getSkillRegistry().getSkill(skillName2);
            if (skill == null || (playerData32 = this.plugin.getPlayerManager().getPlayerData(player)) == null) continue;
            switch (id) {
                case "xp_required_formatted_": {
                    return BigNumber.withSuffix(this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData32.getSkillLevel(skill) + 1));
                }
                case "xp_required_": {
                    return String.valueOf(this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData32.getSkillLevel(skill) + 1));
                }
                case "xp_progress_int_": {
                    return String.valueOf(Math.round(playerData32.getSkillXp(skill) / (double)this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData32.getSkillLevel(skill) + 1) * 100.0));
                }
                case "xp_progress_1_": {
                    return NumberUtil.format1(playerData32.getSkillXp(skill) / (double)this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData32.getSkillLevel(skill) + 1) * 100.0);
                }
                case "xp_progress_": {
                    return String.valueOf(playerData32.getSkillXp(skill) / (double)this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, playerData32.getSkillLevel(skill) + 1) * 100.0);
                }
                case "xp_int_": {
                    return String.valueOf(Math.round(playerData32.getSkillXp(skill)));
                }
                case "xp_formatted_": {
                    return BigNumber.withSuffix(Math.round(playerData32.getSkillXp(skill)));
                }
                case "xp_": {
                    return String.valueOf(playerData32.getSkillXp(skill));
                }
            }
        }
        if (identifier.startsWith("multiplier")) {
            if (identifier.equals("multiplier")) {
                return NumberUtil.format2(this.plugin.getLeveler().getMultiplier(player));
            }
            String string = TextUtil.replace(identifier, "multiplier_", "");
            Skill skill = this.plugin.getSkillRegistry().getSkill(string);
            if (skill != null) {
                return NumberUtil.format2(this.plugin.getLeveler().getMultiplier(player, skill));
            }
        }
        if (identifier.startsWith("multiplier_percent")) {
            if (identifier.equals("multiplier_percent")) {
                return String.valueOf(Math.round((this.plugin.getLeveler().getMultiplier(player) - 1.0) * 100.0));
            }
            String string = TextUtil.replace(identifier, "multiplier_percent_", "");
            Skill skill = this.plugin.getSkillRegistry().getSkill(string);
            if (skill != null) {
                return String.valueOf(Math.round((this.plugin.getLeveler().getMultiplier(player, skill) - 1.0) * 100.0));
            }
        }
        return null;
    }
}

