/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.stats;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.stats.Stats;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.AnvilInventory;

public class Wisdom
implements Listener {
    private final AureliumSkills plugin;

    public Wisdom(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        event.setAmount((int)((double)event.getAmount() * (1.0 + playerData.getStatLevel(Stats.WISDOM) * OptionL.getDouble(Option.WISDOM_EXPERIENCE_MODIFIER))));
    }

    @EventHandler
    public void onAnvilPrepare(PrepareAnvilEvent event) {
        PlayerData playerData = null;
        for (HumanEntity entity : event.getViewers()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            PlayerData checkedPlayerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (checkedPlayerData == null) continue;
            if (playerData == null) {
                playerData = checkedPlayerData;
                continue;
            }
            if (!(playerData.getStatLevel(Stats.WISDOM) < checkedPlayerData.getStatLevel(Stats.WISDOM))) continue;
            playerData = checkedPlayerData;
        }
        if (playerData != null) {
            AnvilInventory anvil = event.getInventory();
            double wisdom = playerData.getStatLevel(Stats.WISDOM) * OptionL.getDouble(Option.WISDOM_ANVIL_COST_MODIFIER);
            int cost = (int)Math.round((double)anvil.getRepairCost() * (1.0 - (-1.0 * Math.pow(1.025, -1.0 * wisdom) + 1.0)));
            if (cost > 0) {
                anvil.setRepairCost(cost);
            } else {
                anvil.setRepairCost(1);
            }
        }
    }
}

