/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.stats;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.api.event.CustomRegenEvent;
import com.archyx.aureliumskills.api.event.RegenReason;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.stats.Stats;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.plugin.Plugin;

public class Regeneration
implements Listener {
    private final AureliumSkills plugin;

    public Regeneration(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRegen(EntityRegainHealthEvent event) {
        if (event.getEntity() instanceof Player && event.getRegainReason().equals((Object)EntityRegainHealthEvent.RegainReason.SATIATED)) {
            Player player = (Player)event.getEntity();
            if (!this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                if (!OptionL.getBoolean(Option.REGENERATION_CUSTOM_REGEN_MECHANICS)) {
                    PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                    if (playerData == null) {
                        return;
                    }
                    if (player.getSaturation() > 0.0f) {
                        event.setAmount(event.getAmount() + playerData.getStatLevel(Stats.REGENERATION) * OptionL.getDouble(Option.REGENERATION_SATURATED_MODIFIER));
                    } else if (player.getFoodLevel() == 20) {
                        event.setAmount(event.getAmount() + playerData.getStatLevel(Stats.REGENERATION) * OptionL.getDouble(Option.REGENERATION_HUNGER_FULL_MODIFIER));
                    } else if (player.getFoodLevel() >= 14) {
                        event.setAmount(event.getAmount() + playerData.getStatLevel(Stats.REGENERATION) * OptionL.getDouble(Option.REGENERATION_HUNGER_ALMOST_FULL_MODIFIER));
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }

    public void startRegen() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (OptionL.getBoolean(Option.REGENERATION_CUSTOM_REGEN_MECHANICS)) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    CustomRegenEvent event;
                    double amountGained;
                    AttributeInstance attribute;
                    PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                    if (playerData == null || this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) || player.isDead() || (attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH)) == null || !(player.getHealth() < attribute.getValue())) continue;
                    if (player.getFoodLevel() >= 14 && player.getFoodLevel() < 20) {
                        amountGained = Math.min(OptionL.getDouble(Option.REGENERATION_BASE_REGEN) + playerData.getStatLevel(Stats.REGENERATION) * OptionL.getDouble(Option.REGENERATION_HUNGER_ALMOST_FULL_MODIFIER), attribute.getValue() - player.getHealth());
                        event = new CustomRegenEvent(player, amountGained, RegenReason.HUNGER_FULL);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) continue;
                        player.setHealth(player.getHealth() + amountGained);
                        if (player.getFoodLevel() - 1 < 0) continue;
                        player.setFoodLevel(player.getFoodLevel() - 1);
                        continue;
                    }
                    if (player.getFoodLevel() != 20 || player.getSaturation() != 0.0f) continue;
                    amountGained = Math.min(OptionL.getDouble(Option.REGENERATION_BASE_REGEN) + playerData.getStatLevel(Stats.REGENERATION) * OptionL.getDouble(Option.REGENERATION_HUNGER_FULL_MODIFIER), attribute.getValue() - player.getHealth());
                    event = new CustomRegenEvent(player, amountGained, RegenReason.HUNGER_ALMOST_FULL);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    player.setHealth(player.getHealth() + amountGained);
                    if (player.getFoodLevel() - 1 < 0) continue;
                    player.setFoodLevel(player.getFoodLevel() - 1);
                }
            }
        }, 0L, (long)OptionL.getInt(Option.REGENERATION_HUNGER_DELAY));
    }

    public void startSaturationRegen() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (OptionL.getBoolean(Option.REGENERATION_CUSTOM_REGEN_MECHANICS)) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    AttributeInstance attribute;
                    PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                    if (playerData == null || this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) || player.isDead() || !(player.getSaturation() > 0.0f) || player.getFoodLevel() < 20 || (attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH)) == null) continue;
                    double amountGained = Math.min(OptionL.getDouble(Option.REGENERATION_BASE_REGEN) + playerData.getStatLevel(Stats.REGENERATION) * OptionL.getDouble(Option.REGENERATION_SATURATED_MODIFIER), attribute.getValue() - player.getHealth());
                    CustomRegenEvent event = new CustomRegenEvent(player, amountGained, RegenReason.SATURATED);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    player.setHealth(player.getHealth() + amountGained);
                }
            }
        }, 0L, (long)OptionL.getInt(Option.REGENERATION_SATURATED_DELAY));
    }
}

