/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.stats;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.support.WorldGuardFlags;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.inventory.ItemStack;

public class Luck
implements Listener {
    private final Random r = new Random();
    private final AureliumSkills plugin;

    public Luck(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerDataLoadEvent event) {
        this.setLuck(event.getPlayerData().getPlayer());
    }

    public void reload(Player player) {
        if (player != null) {
            this.setLuck(player);
        }
    }

    @EventHandler
    public void worldChange(PlayerChangedWorldEvent event) {
        this.setLuck(event.getPlayer());
    }

    private void setLuck(Player player) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_LUCK);
        if (attribute != null) {
            boolean hasModifier = false;
            for (AttributeModifier am : attribute.getModifiers()) {
                if (!am.getName().equals("AureliumSkills-Luck")) continue;
                attribute.removeModifier(am);
                hasModifier = true;
            }
            if (!hasModifier) {
                attribute.setBaseValue(0.0);
            }
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData != null) {
                double luck = playerData.getStatLevel(Stats.LUCK) * OptionL.getDouble(Option.LUCK_MODIFIER);
                attribute.addModifier(new AttributeModifier("AureliumSkills-Luck", luck, AttributeModifier.Operation.ADD_NUMBER));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (OptionL.getBoolean(Option.LUCK_DOUBLE_DROP_ENABLED) && !event.isCancelled()) {
            Player player = event.getPlayer();
            Block block = event.getBlock();
            if (this.plugin.getWorldManager().isInBlockedWorld(block.getLocation())) {
                return;
            }
            if (this.plugin.isWorldGuardEnabled()) {
                if (this.plugin.getWorldGuardSupport().isInBlockedRegion(block.getLocation())) {
                    return;
                }
                if (this.plugin.getWorldGuardSupport().blockedByFlag(block.getLocation(), player, WorldGuardFlags.FlagKey.XP_GAIN)) {
                    return;
                }
            }
            if (!event.isDropItems()) {
                return;
            }
            if (player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
                if (this.plugin.getRegionManager().isPlacedBlock(block)) {
                    return;
                }
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                Material mat = block.getType();
                if (mat.equals((Object)Material.STONE) || mat.equals((Object)Material.COBBLESTONE) || mat.equals((Object)Material.SAND) || mat.equals((Object)Material.GRAVEL) || mat.equals((Object)Material.DIRT) || mat.equals((Object)XMaterial.GRASS_BLOCK.parseMaterial()) || mat.equals((Object)XMaterial.ANDESITE.parseMaterial()) || mat.equals((Object)XMaterial.DIORITE.parseMaterial()) || mat.equals((Object)XMaterial.GRANITE.parseMaterial())) {
                    double chance = playerData.getStatLevel(Stats.LUCK) * OptionL.getDouble(Option.LUCK_DOUBLE_DROP_MODIFIER);
                    if (chance * 100.0 > OptionL.getDouble(Option.LUCK_DOUBLE_DROP_PERCENT_MAX)) {
                        chance = OptionL.getDouble(Option.LUCK_DOUBLE_DROP_PERCENT_MAX);
                    }
                    if (this.r.nextDouble() < chance) {
                        ItemStack tool = player.getInventory().getItemInMainHand();
                        for (ItemStack item : block.getDrops(tool)) {
                            PlayerLootDropEvent dropEvent;
                            if (tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0) {
                                if (mat.equals((Object)Material.STONE)) {
                                    if (!XMaterial.isNewVersion()) {
                                        if (block.getData() != 0) continue;
                                        dropEvent = new PlayerLootDropEvent(player, new ItemStack(Material.STONE), block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.LUCK_DOUBLE_DROP);
                                        Bukkit.getPluginManager().callEvent((Event)dropEvent);
                                        if (event.isCancelled()) continue;
                                        block.getWorld().dropItem(dropEvent.getLocation(), dropEvent.getItemStack());
                                        continue;
                                    }
                                    dropEvent = new PlayerLootDropEvent(player, new ItemStack(Material.STONE), block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.LUCK_DOUBLE_DROP);
                                    Bukkit.getPluginManager().callEvent((Event)dropEvent);
                                    if (event.isCancelled()) continue;
                                    block.getWorld().dropItem(dropEvent.getLocation(), dropEvent.getItemStack());
                                    continue;
                                }
                                if (!mat.equals((Object)XMaterial.GRASS_BLOCK.parseMaterial())) continue;
                                Material grassBlock = XMaterial.GRASS_BLOCK.parseMaterial();
                                PlayerLootDropEvent dropEvent2 = new PlayerLootDropEvent(player, new ItemStack(grassBlock), block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.LUCK_DOUBLE_DROP);
                                Bukkit.getPluginManager().callEvent((Event)dropEvent2);
                                if (event.isCancelled()) continue;
                                block.getWorld().dropItem(dropEvent2.getLocation(), dropEvent2.getItemStack());
                                continue;
                            }
                            dropEvent = new PlayerLootDropEvent(player, item.clone(), block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.LUCK_DOUBLE_DROP);
                            Bukkit.getPluginManager().callEvent((Event)dropEvent);
                            if (event.isCancelled()) continue;
                            block.getWorld().dropItem(dropEvent.getLocation(), dropEvent.getItemStack());
                        }
                    }
                }
            }
        }
    }
}

