/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.stats;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.skills.agility.AgilityAbilities;
import com.archyx.aureliumskills.stats.Stats;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Health
implements Listener {
    private final AureliumSkills plugin;
    private final AgilityAbilities agilityAbilities;
    private final Map<UUID, Double> worldChangeHealth = new HashMap<UUID, Double>();
    private final Map<Integer, Double> hearts = new HashMap<Integer, Double>();
    private static final double threshold = 0.1;

    public Health(AureliumSkills plugin) {
        this.plugin = plugin;
        this.agilityAbilities = new AgilityAbilities(plugin);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.applyScaling(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLoad(PlayerDataLoadEvent event) {
        this.setHealth(event.getPlayerData().getPlayer());
    }

    public void reload(Player player) {
        if (player != null) {
            this.setHealth(player);
            this.agilityAbilities.removeFleeting(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void worldChange(final PlayerChangedWorldEvent event) {
        final Player player = event.getPlayer();
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) && !this.plugin.getWorldManager().isDisabledWorld(event.getFrom())) {
            this.worldChangeHealth.put(player.getUniqueId(), player.getHealth());
        }
        if (OptionL.getInt(Option.HEALTH_UPDATE_DELAY) > 0) {
            new BukkitRunnable(){

                public void run() {
                    Health.this.setHealth(player);
                    if (Health.this.plugin.getWorldManager().isDisabledWorld(event.getFrom()) && !Health.this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) && Health.this.worldChangeHealth.containsKey(player.getUniqueId())) {
                        player.setHealth(((Double)Health.this.worldChangeHealth.get(player.getUniqueId())).doubleValue());
                        Health.this.worldChangeHealth.remove(player.getUniqueId());
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)OptionL.getInt(Option.HEALTH_UPDATE_DELAY));
        } else {
            this.setHealth(player);
            if (this.plugin.getWorldManager().isDisabledWorld(event.getFrom()) && !this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) && this.worldChangeHealth.containsKey(player.getUniqueId())) {
                player.setHealth(this.worldChangeHealth.get(player.getUniqueId()).doubleValue());
                this.worldChangeHealth.remove(player.getUniqueId());
            }
        }
    }

    private void setHealth(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        double modifier = playerData.getStatLevel(Stats.HEALTH) * OptionL.getDouble(Option.HEALTH_MODIFIER);
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        double originalMaxHealth = attribute.getValue();
        boolean hasChange = true;
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!am.getName().equals("skillsHealth")) continue;
            if (Math.abs(originalMaxHealth - (originalMaxHealth - am.getAmount() + modifier)) <= 0.1) {
                hasChange = false;
            }
            if (!hasChange) continue;
            attribute.removeModifier(am);
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            player.setHealthScaled(false);
            for (AttributeModifier am : attribute.getModifiers()) {
                if (!am.getName().equals("skillsHealth")) continue;
                attribute.removeModifier(am);
            }
            return;
        }
        if (OptionL.getBoolean(Option.HEALTH_FORCE_BASE_HEALTH)) {
            attribute.setBaseValue(20.0);
        }
        if (hasChange) {
            attribute.addModifier(new AttributeModifier("skillsHealth", modifier, AttributeModifier.Operation.ADD_NUMBER));
            if (player.getHealth() > attribute.getValue()) {
                player.setHealth(attribute.getValue());
            }
            if (OptionL.getBoolean(Option.HEALTH_KEEP_FULL_ON_INCREASE) && attribute.getValue() > originalMaxHealth && player.getHealth() >= originalMaxHealth) {
                player.setHealth(attribute.getValue());
            }
        }
        this.applyScaling(player);
    }

    private void applyScaling(Player player) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        if (OptionL.getBoolean(Option.HEALTH_HEALTH_SCALING)) {
            double health = attribute.getValue();
            player.setHealthScaled(true);
            int scaledHearts = 0;
            for (Integer heartNum : this.hearts.keySet()) {
                double healthNum = this.hearts.get(heartNum);
                if (!(health >= healthNum) || heartNum <= scaledHearts) continue;
                scaledHearts = heartNum;
            }
            if (scaledHearts == 0) {
                scaledHearts = 10;
            }
            player.setHealthScale((double)(scaledHearts * 2));
        } else {
            player.setHealthScaled(false);
        }
    }

    public void loadHearts(FileConfiguration config) {
        this.hearts.clear();
        this.hearts.put(10, 0.0);
        this.hearts.put(11, 24.0);
        this.hearts.put(12, 29.0);
        this.hearts.put(13, 37.0);
        this.hearts.put(14, 50.0);
        this.hearts.put(15, 71.0);
        this.hearts.put(16, 105.0);
        this.hearts.put(17, 160.0);
        this.hearts.put(18, 249.0);
        this.hearts.put(19, 393.0);
        this.hearts.put(20, 626.0);
        ConfigurationSection heartsSection = config.getConfigurationSection("health.hearts");
        if (heartsSection != null) {
            try {
                for (String key : heartsSection.getKeys(false)) {
                    int heartsNum = Integer.parseInt(key);
                    double healthNum = heartsSection.getDouble(key, -1.0);
                    if (healthNum == -1.0) continue;
                    this.hearts.put(heartsNum, healthNum);
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[AureliumSkills] There was an error loading health.hearts data! Check to make sure the keys are only integers and the values are only numbers.");
            }
        }
    }
}

