/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.source;

import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.source.Source;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class SourceRegistry {
    private final Map<Skill, Class<?>> registry = new HashMap();

    public SourceRegistry() {
        try {
            for (Skills skill : Skills.values()) {
                String className = StringUtils.capitalize((String)skill.toString().toLowerCase(Locale.ROOT)) + "Source";
                Class<?> sourceClass = Class.forName("com.archyx.aureliumskills.skills." + skill.toString().toLowerCase(Locale.ROOT) + "." + className);
                this.registry.put(skill, sourceClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void register(Skill skill, Class<? extends Source> sourceClass) {
        this.registry.put(skill, sourceClass);
    }

    public Source[] values(Skill skill) {
        Class<?> sourceClass = this.registry.get(skill);
        if (sourceClass != null) {
            try {
                Method method = sourceClass.getMethod("values", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                if (object instanceof Source[]) {
                    return (Source[])object;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new Source[0];
    }

    public Set<Source> values() {
        HashSet<Source> sourceSet = new HashSet<Source>();
        for (Class<?> sourceClass : this.registry.values()) {
            try {
                Method method = sourceClass.getMethod("values", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                if (!(object instanceof Source[])) continue;
                sourceSet.addAll(Arrays.asList((Source[])object));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return sourceSet;
    }

    @Nullable
    public Source valueOf(String sourceString) {
        for (Source source : this.values()) {
            if (!source.toString().equals(sourceString.toUpperCase(Locale.ROOT))) continue;
            return source;
        }
        return null;
    }
}

