/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.source;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.source.Source;
import com.archyx.aureliumskills.source.SourceTag;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class SourceManager {
    private final AureliumSkills plugin;
    private final Map<Source, Double> sources;
    private final Map<SourceTag, List<Source>> tags;
    private Map<Skill, Map<XMaterial, Double>> customBlocks;
    private Map<Skill, Map<String, Double>> customMobs;
    private Set<XMaterial> customBlockSet;
    private Set<String> customMobSet;

    public SourceManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.sources = new HashMap<Source, Double>();
        this.tags = new HashMap<SourceTag, List<Source>>();
    }

    public void loadSources() {
        Skill[] customMobSkills;
        Skill[] skillArray;
        long start = System.currentTimeMillis();
        File file = new File(this.plugin.getDataFolder(), "sources_config.yml");
        if (!file.exists()) {
            this.plugin.saveResource("sources_config.yml", false);
        }
        FileConfiguration config = this.updateFile(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        int sourcesLoaded = 0;
        for (Source source : this.plugin.getSourceRegistry().values()) {
            String path = source.getPath();
            if (config.contains("sources." + path)) {
                this.sources.put(source, config.getDouble("sources." + path));
                ++sourcesLoaded;
                continue;
            }
            Bukkit.getLogger().warning("[AureliumSkills] sources_config.yml is missing source of path sources." + path + ", value has been set to 0");
            this.sources.put(source, 0.0);
        }
        int tagsLoaded = 0;
        for (SourceTag tag : SourceTag.values()) {
            String path = tag.getPath();
            if (config.contains("tags." + path)) {
                List sourceStringList = config.getStringList("tags." + path);
                ArrayList<Source> sourcesList = new ArrayList<Source>();
                for (String sourceString : sourceStringList) {
                    Source source;
                    if (sourceString.equals("*")) {
                        sourcesList.addAll(Arrays.asList(this.plugin.getSourceRegistry().values(tag.getSkill())));
                        continue;
                    }
                    if (sourceString.startsWith("!")) {
                        source = this.plugin.getSourceRegistry().valueOf(sourceString.substring(1));
                        if (source == null) continue;
                        sourcesList.remove(source);
                        continue;
                    }
                    source = this.plugin.getSourceRegistry().valueOf(sourceString);
                    if (source == null) continue;
                    sourcesList.add(source);
                }
                this.tags.put(tag, sourcesList);
                ++tagsLoaded;
                continue;
            }
            this.plugin.getLogger().warning("sources_config.yml is missing tag of path tags." + path + ", tag will be empty");
            this.tags.put(tag, new ArrayList());
        }
        this.customBlocks = new HashMap<Skill, Map<XMaterial, Double>>();
        this.customBlockSet = new HashSet<XMaterial>();
        for (Skill skill : skillArray = new Skill[]{Skills.FARMING, Skills.FORAGING, Skills.MINING, Skills.EXCAVATION}) {
            ConfigurationSection section = config.getConfigurationSection("sources." + skill.toString().toLowerCase(Locale.ENGLISH) + ".custom");
            if (section == null) continue;
            HashMap<XMaterial, Double> blockMap = new HashMap<XMaterial, Double>();
            for (String key : section.getKeys(false)) {
                double value = section.getDouble(key);
                Optional<XMaterial> optionalMaterial = XMaterial.matchXMaterial(key.toUpperCase());
                if (optionalMaterial.isPresent()) {
                    XMaterial material = optionalMaterial.get();
                    blockMap.put(material, value);
                    this.customBlockSet.add(material);
                    ++sourcesLoaded;
                    continue;
                }
                Bukkit.getLogger().warning("[AureliumSkills] Custom block " + key + " is not a valid block!");
            }
            this.customBlocks.put(skill, blockMap);
        }
        this.customMobs = new HashMap<Skill, Map<String, Double>>();
        this.customMobSet = new HashSet<String>();
        for (Skill skill : customMobSkills = new Skill[]{Skills.FIGHTING, Skills.ARCHERY}) {
            ConfigurationSection section = config.getConfigurationSection("sources." + skill.toString().toLowerCase(Locale.ENGLISH) + ".custom");
            if (section == null) continue;
            HashMap<String, Double> mobMap = new HashMap<String, Double>();
            for (String key : section.getKeys(false)) {
                double value = section.getDouble(key);
                mobMap.put(key, value);
                this.customMobSet.add(key);
                ++sourcesLoaded;
            }
            this.customMobs.put(skill, mobMap);
        }
        Bukkit.getLogger().info("[AureliumSkills] Loaded " + sourcesLoaded + " sources and " + tagsLoaded + " tags in " + (System.currentTimeMillis() - start) + "ms");
    }

    private FileConfiguration updateFile(File file, FileConfiguration config) {
        YamlConfiguration imbConfig;
        int imbVersion;
        int currentVersion;
        InputStream stream;
        if (config.contains("file_version") && (stream = this.plugin.getResource("sources_config.yml")) != null && (currentVersion = config.getInt("file_version")) != (imbVersion = (imbConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream))).getInt("file_version"))) {
            try {
                ConfigurationSection configSection = imbConfig.getConfigurationSection("");
                int keysAdded = 0;
                if (configSection != null) {
                    for (String key : configSection.getKeys(true)) {
                        if (config.contains(key)) continue;
                        config.set(key, imbConfig.get(key));
                        ++keysAdded;
                    }
                }
                config.set("file_version", (Object)imbVersion);
                config.save(file);
                Bukkit.getLogger().info("[AureliumSkills] sources_config.yml was updated to a new file version, " + keysAdded + " new keys were added.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public double getXp(Source source) {
        return this.sources.get(source);
    }

    @NotNull
    public List<Source> getTag(SourceTag tag) {
        return this.tags.getOrDefault((Object)tag, new ArrayList());
    }

    public Map<XMaterial, Double> getCustomBlocks(Skill skill) {
        return this.customBlocks.get(skill);
    }

    public Set<XMaterial> getCustomBlockSet() {
        return this.customBlockSet;
    }

    public Map<String, Double> getCustomMobs(Skill skill) {
        return this.customMobs.get(skill);
    }

    public Set<String> getCustomMobSet() {
        return this.customMobSet;
    }
}

