/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.mining;

import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.source.BlockSource;
import com.archyx.aureliumskills.source.Source;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public enum MiningSource implements Source,
BlockSource
{
    STONE("STONE", 0),
    COBBLESTONE,
    GRANITE("STONE", 1),
    DIORITE("STONE", 2),
    ANDESITE("STONE", 5),
    COAL_ORE,
    IRON_ORE,
    NETHER_QUARTZ_ORE("QUARTZ_ORE"),
    REDSTONE_ORE("GLOWING_REDSTONE_ORE", true),
    GOLD_ORE,
    LAPIS_ORE,
    DIAMOND_ORE,
    EMERALD_ORE,
    TERRACOTTA("HARD_CLAY"),
    WHITE_TERRACOTTA("STAINED_CLAY", 0),
    ORANGE_TERRACOTTA("ORANGE_TERRACOTTA", 1),
    YELLOW_TERRACOTTA("STAINED_CLAY", 4),
    LIGHT_GRAY_TERRACOTTA("STAINED_CLAY", 8),
    BROWN_TERRACOTTA("STAINED_CLAY", 12),
    RED_TERRACOTTA("STAINED_CLAY", 14),
    NETHERRACK,
    BLACKSTONE,
    BASALT,
    MAGMA_BLOCK("MAGMA"),
    NETHER_GOLD_ORE,
    ANCIENT_DEBRIS,
    END_STONE("ENDER_STONE"),
    OBSIDIAN,
    DEEPSLATE,
    COPPER_ORE,
    TUFF,
    CALCITE,
    SMOOTH_BASALT,
    AMETHYST_BLOCK,
    AMETHYST_CLUSTER,
    DEEPSLATE_COAL_ORE,
    DEEPSLATE_IRON_ORE,
    DEEPSLATE_COPPER_ORE,
    DEEPSLATE_GOLD_ORE,
    DEEPSLATE_REDSTONE_ORE,
    DEEPSLATE_EMERALD_ORE,
    DEEPSLATE_LAPIS_ORE,
    DEEPSLATE_DIAMOND_ORE,
    DRIPSTONE_BLOCK,
    ICE(true),
    PACKED_ICE(true),
    BLUE_ICE(true);

    private final String legacyMaterial;
    private final byte legacyData;
    private final boolean allowBothIfLegacy;
    private boolean requiresSilkTouch;

    private MiningSource() {
        this(null, -1, false);
    }

    private MiningSource(boolean requiresSilkTouch) {
        this(null, -1, false);
        this.requiresSilkTouch = requiresSilkTouch;
    }

    private MiningSource(String legacyMaterial) {
        this(legacyMaterial, -1, false);
    }

    private MiningSource(String legacyMaterial, int legacyData) {
        this(legacyMaterial, legacyData, false);
    }

    private MiningSource(String legacyMaterial, boolean allowBothIfLegacy) {
        this(legacyMaterial, -1, allowBothIfLegacy);
    }

    private MiningSource(String legacyMaterial, int legacyData, boolean allowBothIfLegacy) {
        this.legacyMaterial = legacyMaterial;
        this.legacyData = (byte)legacyData;
        this.allowBothIfLegacy = allowBothIfLegacy;
    }

    @Override
    @Nullable
    public String getLegacyMaterial() {
        return this.legacyMaterial;
    }

    @Override
    public byte getLegacyData() {
        return this.legacyData;
    }

    @Override
    public boolean allowBothIfLegacy() {
        return this.allowBothIfLegacy;
    }

    public boolean requiresSilkTouch() {
        return this.requiresSilkTouch;
    }

    @Override
    public Skill getSkill() {
        return Skills.MINING;
    }

    @Nullable
    public static MiningSource getSource(Block block) {
        for (MiningSource source : MiningSource.values()) {
            if (!source.isMatch(block)) continue;
            return source;
        }
        return null;
    }
}

