/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.mining;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.mining.MiningAbilities;
import com.archyx.aureliumskills.skills.mining.MiningSource;
import com.archyx.aureliumskills.source.SourceTag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class MiningLeveler
extends SkillLeveler
implements Listener {
    private final MiningAbilities miningAbilities;

    public MiningLeveler(AureliumSkills plugin) {
        super(plugin, Ability.MINER);
        this.miningAbilities = new MiningAbilities(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (OptionL.isEnabled(Skills.MINING)) {
            if (OptionL.getBoolean(Option.MINING_CHECK_CANCELLED) && event.isCancelled()) {
                return;
            }
            Block block = event.getBlock();
            if (OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
                return;
            }
            Player player = event.getPlayer();
            if (this.blockXpGainLocation(block.getLocation(), player)) {
                return;
            }
            if (this.blockXpGainPlayer(player)) {
                return;
            }
            for (MiningSource source : MiningSource.values()) {
                if (!source.isMatch(block)) continue;
                if (source.requiresSilkTouch() && !this.hasSilkTouch(player)) {
                    return;
                }
                this.plugin.getLeveler().addXp(player, Skills.MINING, this.getXp(player, source));
                if (!this.hasTag(source, SourceTag.LUCKY_MINER_APPLICABLE) || !event.isDropItems()) break;
                this.miningAbilities.luckyMiner(player, block, source);
                break;
            }
            this.checkCustomBlocks(player, block, Skills.MINING);
        }
    }
}

