/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.mining;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.mining.MiningSource;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.version.VersionUtils;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;

public class MiningAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public MiningAbilities(AureliumSkills plugin) {
        super(plugin, Skills.MINING);
    }

    public void luckyMiner(Player player, Block block, MiningSource source) {
        if (OptionL.isEnabled(Skills.MINING) && this.plugin.getAbilityManager().isEnabled(Ability.LUCKY_MINER) && player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.LUCKY_MINER) > 0 && this.r.nextDouble() < this.getValue(Ability.LUCKY_MINER, playerData) / 100.0) {
                ItemStack tool = player.getInventory().getItemInMainHand();
                Material mat = block.getType();
                if (tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0) {
                    if (mat.equals((Object)Material.DIAMOND_ORE) || mat.equals((Object)Material.LAPIS_ORE) || mat.equals((Object)Material.REDSTONE_ORE) || mat.name().equals("GLOWING_REDSTONE_ORE") || mat.equals((Object)Material.EMERALD_ORE) || mat.equals((Object)Material.COAL_ORE) || mat.equals((Object)XMaterial.NETHER_QUARTZ_ORE.parseMaterial()) || mat.equals((Object)XMaterial.NETHER_GOLD_ORE.parseMaterial())) {
                        return;
                    }
                    if (VersionUtils.isAtLeastVersion(17) && (mat == Material.IRON_ORE || mat == Material.GOLD_ORE || mat == Material.COPPER_ORE || source.toString().contains("DEEPSLATE_"))) {
                        return;
                    }
                }
                Collection drops = block.getDrops(tool);
                for (ItemStack item : drops) {
                    PlayerLootDropEvent event = new PlayerLootDropEvent(player, item.clone(), block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.LUCKY_MINER);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    block.getWorld().dropItem(event.getLocation(), event.getItemStack());
                }
            }
        }
    }

    public void pickMaster(EntityDamageByEntityEvent event, Player player, PlayerData playerData) {
        if (OptionL.isEnabled(Skills.MINING) && this.plugin.getAbilityManager().isEnabled(Ability.PICK_MASTER)) {
            if (!player.hasPermission("aureliumskills.mining")) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.PICK_MASTER) > 0) {
                event.setDamage(event.getDamage() * (1.0 + this.getValue(Ability.PICK_MASTER, playerData) / 100.0));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void hardenedArmor(PlayerItemDamageEvent event) {
        if (this.blockDisabled(Ability.HARDENED_ARMOR)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        if (ItemUtils.isArmor(event.getItem().getType())) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (this.r.nextDouble() < this.getValue(Ability.HARDENED_ARMOR, playerData) / 100.0) {
                event.setCancelled(true);
            }
        }
    }

    public void applyStamina(PlayerData playerData) {
        if (OptionL.isEnabled(Skills.MINING) && this.plugin.getAbilityManager().isEnabled(Ability.STAMINA) && playerData.getAbilityLevel(Ability.STAMINA) > 0) {
            playerData.addStatModifier(new StatModifier("mining-stamina", Stats.TOUGHNESS, (int)this.getValue(Ability.STAMINA, playerData)));
        }
    }

    public void removeStamina(PlayerData playerData) {
        playerData.removeStatModifier("mining-stamina");
    }
}

