/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.healing;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.Leveler;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.healing.HealingSource;
import com.archyx.aureliumskills.util.mechanics.PotionUtil;
import com.archyx.aureliumskills.util.version.VersionUtils;
import com.archyx.aureliumskills.xseries.XMaterial;
import org.bukkit.Material;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class HealingLeveler
extends SkillLeveler
implements Listener {
    public HealingLeveler(AureliumSkills plugin) {
        super(plugin, Ability.HEALER);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onConsume(PlayerItemConsumeEvent event) {
        if (OptionL.isEnabled(Skills.HEALING)) {
            MaterialData materialData;
            if (OptionL.getBoolean(Option.HEALING_CHECK_CANCELLED) && event.isCancelled()) {
                return;
            }
            if (this.blockXpGain(event.getPlayer())) {
                return;
            }
            Player player = event.getPlayer();
            Skills skill = Skills.HEALING;
            Leveler leveler = this.plugin.getLeveler();
            if (event.getItem().getType().equals((Object)Material.POTION)) {
                if (event.getItem().getItemMeta() instanceof PotionMeta) {
                    PotionMeta meta = (PotionMeta)event.getItem().getItemMeta();
                    PotionData data = meta.getBasePotionData();
                    if (OptionL.getBoolean(Option.HEALING_EXCLUDE_NEGATIVE_POTIONS) && PotionUtil.isNegativePotion(data.getType())) {
                        return;
                    }
                    if (!(data.getType().equals((Object)PotionType.MUNDANE) || data.getType().equals((Object)PotionType.THICK) || data.getType().equals((Object)PotionType.WATER) || data.getType().equals((Object)PotionType.AWKWARD))) {
                        if (data.isExtended()) {
                            leveler.addXp(player, skill, this.getXp(player, HealingSource.DRINK_EXTENDED));
                        } else if (data.isUpgraded()) {
                            leveler.addXp(player, skill, this.getXp(player, HealingSource.DRINK_UPGRADED));
                        } else {
                            leveler.addXp(player, skill, this.getXp(player, HealingSource.DRINK_REGULAR));
                        }
                    }
                }
            } else if (XMaterial.isNewVersion()) {
                if (event.getItem().getType().equals((Object)Material.GOLDEN_APPLE)) {
                    leveler.addXp(player, skill, this.getXp(player, HealingSource.GOLDEN_APPLE));
                } else if (event.getItem().getType().equals((Object)XMaterial.ENCHANTED_GOLDEN_APPLE.parseMaterial())) {
                    leveler.addXp(player, skill, this.getXp(player, HealingSource.ENCHANTED_GOLDEN_APPLE));
                }
            } else if (event.getItem().getType().equals((Object)Material.GOLDEN_APPLE) && (materialData = event.getItem().getData()) != null) {
                if (materialData.getData() == 0) {
                    leveler.addXp(player, skill, this.getXp(player, HealingSource.GOLDEN_APPLE));
                } else if (materialData.getData() == 1) {
                    leveler.addXp(player, skill, this.getXp(player, HealingSource.ENCHANTED_GOLDEN_APPLE));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onThrow(PotionSplashEvent event) {
        if (OptionL.isEnabled(Skills.HEALING)) {
            if (OptionL.getBoolean(Option.HEALING_CHECK_CANCELLED) && event.isCancelled()) {
                return;
            }
            if (event.getPotion().getEffects().size() > 0 && event.getEntity().getShooter() instanceof Player && event.getPotion().getItem().getItemMeta() instanceof PotionMeta) {
                Player player = (Player)event.getEntity().getShooter();
                PotionMeta meta = (PotionMeta)event.getPotion().getItem().getItemMeta();
                PotionData data = meta.getBasePotionData();
                if (OptionL.getBoolean(Option.HEALING_EXCLUDE_NEGATIVE_POTIONS) && PotionUtil.isNegativePotion(data.getType())) {
                    return;
                }
                Skills skill = Skills.HEALING;
                if (this.blockXpGain(player)) {
                    return;
                }
                if (!(data.getType().equals((Object)PotionType.MUNDANE) || data.getType().equals((Object)PotionType.THICK) || data.getType().equals((Object)PotionType.WATER) || data.getType().equals((Object)PotionType.AWKWARD))) {
                    if (data.isExtended()) {
                        this.plugin.getLeveler().addXp(player, skill, this.getXp(player, HealingSource.SPLASH_EXTENDED));
                    } else if (data.isUpgraded()) {
                        this.plugin.getLeveler().addXp(player, skill, this.getXp(player, HealingSource.SPLASH_UPGRADED));
                    } else {
                        this.plugin.getLeveler().addXp(player, skill, this.getXp(player, HealingSource.SPLASH_REGULAR));
                    }
                }
            }
        }
    }

    @EventHandler
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        PotionMeta meta;
        if (!OptionL.isEnabled(Skills.HEALING)) {
            return;
        }
        if (OptionL.getBoolean(Option.HEALING_CHECK_CANCELLED) && event.isCancelled()) {
            return;
        }
        LingeringPotionSplashEvent projEvent = event;
        if (!(projEvent.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projEvent.getEntity().getShooter();
        if (player == null) {
            return;
        }
        Projectile projectile = projEvent.getEntity();
        if (VersionUtils.isAtLeastVersion(14)) {
            if (!(projectile instanceof ThrownPotion)) {
                return;
            }
            ThrownPotion thrownPotion = (ThrownPotion)projectile;
            if (thrownPotion.getEffects().size() == 0) {
                return;
            }
            if (!(thrownPotion.getItem().getItemMeta() instanceof PotionMeta)) {
                return;
            }
            meta = (PotionMeta)thrownPotion.getItem().getItemMeta();
        } else {
            if (!(projectile instanceof LingeringPotion)) {
                return;
            }
            LingeringPotion lingeringPotion = (LingeringPotion)projectile;
            if (lingeringPotion.getEffects().size() == 0) {
                return;
            }
            if (!(lingeringPotion.getItem().getItemMeta() instanceof PotionMeta)) {
                return;
            }
            meta = (PotionMeta)lingeringPotion.getItem().getItemMeta();
        }
        PotionData data = meta.getBasePotionData();
        if (OptionL.getBoolean(Option.HEALING_EXCLUDE_NEGATIVE_POTIONS) && PotionUtil.isNegativePotion(data.getType())) {
            return;
        }
        Skills skill = Skills.HEALING;
        if (this.blockXpGain(player)) {
            return;
        }
        if (!(data.getType().equals((Object)PotionType.MUNDANE) || data.getType().equals((Object)PotionType.THICK) || data.getType().equals((Object)PotionType.WATER) || data.getType().equals((Object)PotionType.AWKWARD))) {
            if (data.isExtended()) {
                this.plugin.getLeveler().addXp(player, skill, this.getXp(player, HealingSource.LINGERING_EXTENDED));
            } else if (data.isUpgraded()) {
                this.plugin.getLeveler().addXp(player, skill, this.getXp(player, HealingSource.LINGERING_UPGRADED));
            } else {
                this.plugin.getLeveler().addXp(player, skill, this.getXp(player, HealingSource.LINGERING_REGULAR));
            }
        }
    }
}

