/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.forging;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.forging.ForgingSource;
import com.archyx.aureliumskills.util.item.ItemUtils;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public class ForgingLeveler
extends SkillLeveler
implements Listener {
    public ForgingLeveler(AureliumSkills plugin) {
        super(plugin, Ability.FORGER);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onForge(InventoryClickEvent event) {
        if (OptionL.isEnabled(Skills.FORGING)) {
            if (OptionL.getBoolean(Option.FORGING_CHECK_CANCELLED) && event.isCancelled()) {
                return;
            }
            Inventory inventory = event.getClickedInventory();
            if (inventory != null) {
                if (!(event.getWhoClicked() instanceof Player)) {
                    return;
                }
                Player player = (Player)event.getWhoClicked();
                ClickType click = event.getClick();
                if (click != ClickType.LEFT && click != ClickType.RIGHT && ItemUtils.isInventoryFull(player)) {
                    return;
                }
                if (event.getResult() != Event.Result.ALLOW) {
                    return;
                }
                if (player.getItemOnCursor().getType() != Material.AIR) {
                    return;
                }
                InventoryAction action = event.getAction();
                if (action != InventoryAction.PICKUP_ALL && action != InventoryAction.MOVE_TO_OTHER_INVENTORY && action != InventoryAction.PICKUP_HALF && action != InventoryAction.DROP_ALL_SLOT && action != InventoryAction.DROP_ONE_SLOT && action != InventoryAction.HOTBAR_SWAP) {
                    return;
                }
                if (inventory.getType().equals((Object)InventoryType.ANVIL)) {
                    if (event.getSlot() == 2) {
                        ItemStack addedItem = inventory.getItem(1);
                        ItemStack baseItem = inventory.getItem(0);
                        if (inventory.getLocation() != null ? this.blockXpGainLocation(inventory.getLocation(), player) : this.blockXpGainLocation(event.getWhoClicked().getLocation(), player)) {
                            return;
                        }
                        if (this.blockXpGainPlayer(player)) {
                            return;
                        }
                        Skills s = Skills.FORGING;
                        AnvilInventory anvil = (AnvilInventory)inventory;
                        if (addedItem != null && baseItem != null && addedItem.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                            if (ItemUtils.isArmor(baseItem.getType())) {
                                this.plugin.getLeveler().addXp(player, s, (double)anvil.getRepairCost() * this.getXp(player, ForgingSource.COMBINE_ARMOR_PER_LEVEL));
                            } else if (ItemUtils.isWeapon(baseItem.getType())) {
                                this.plugin.getLeveler().addXp(player, s, (double)anvil.getRepairCost() * this.getXp(player, ForgingSource.COMBINE_WEAPON_PER_LEVEL));
                            } else if (baseItem.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                                this.plugin.getLeveler().addXp(player, s, (double)anvil.getRepairCost() * this.getXp(player, ForgingSource.COMBINE_BOOKS_PER_LEVEL));
                            } else {
                                this.plugin.getLeveler().addXp(player, s, (double)anvil.getRepairCost() * this.getXp(player, ForgingSource.COMBINE_TOOL_PER_LEVEL));
                            }
                        }
                    }
                } else if (inventory.getType().toString().equals("GRINDSTONE")) {
                    if (event.getSlotType() != InventoryType.SlotType.RESULT) {
                        return;
                    }
                    if (inventory.getLocation() != null ? this.blockXpGainLocation(inventory.getLocation(), player) : this.blockXpGainLocation(event.getWhoClicked().getLocation(), player)) {
                        return;
                    }
                    if (this.blockXpGainPlayer(player)) {
                        return;
                    }
                    int totalLevel = 0;
                    ItemStack topItem = inventory.getItem(0);
                    totalLevel += this.getTotalLevel(topItem);
                    ItemStack bottomItem = inventory.getItem(1);
                    this.plugin.getLeveler().addXp(player, Skills.FORGING, (double)(totalLevel += this.getTotalLevel(bottomItem)) * this.getXp(player, ForgingSource.GRINDSTONE_PER_LEVEL));
                }
            }
        }
    }

    private int getTotalLevel(ItemStack item) {
        int totalLevel = 0;
        if (item != null) {
            for (Map.Entry entry : item.getEnchantments().entrySet()) {
                if (((Enchantment)entry.getKey()).equals((Object)Enchantment.BINDING_CURSE) || ((Enchantment)entry.getKey()).equals((Object)Enchantment.VANISHING_CURSE)) continue;
                totalLevel += ((Integer)entry.getValue()).intValue();
            }
            if (item.getItemMeta() instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)item.getItemMeta();
                for (Map.Entry entry : esm.getStoredEnchants().entrySet()) {
                    if (((Enchantment)entry.getKey()).equals((Object)Enchantment.BINDING_CURSE) || ((Enchantment)entry.getKey()).equals((Object)Enchantment.VANISHING_CURSE)) continue;
                    totalLevel += ((Integer)entry.getValue()).intValue();
                }
            }
        }
        return totalLevel;
    }
}

