/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.forging;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.XpGainEvent;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.mechanics.EnchantmentValue;
import com.archyx.aureliumskills.util.mechanics.GrindstoneEnchant;
import com.archyx.aureliumskills.util.version.VersionUtils;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ForgingAbilities
extends AbilityProvider
implements Listener {
    private final Random random = new Random();

    public ForgingAbilities(AureliumSkills plugin) {
        super(plugin, Skills.FORGING);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void disenchanter(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.blockDisabled(Ability.DISENCHANTER)) {
            return;
        }
        if (!VersionUtils.isAtLeastVersion(14)) {
            return;
        }
        if (event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            if (this.blockAbility(player)) {
                return;
            }
            Inventory inventory = event.getClickedInventory();
            if (inventory == null) {
                return;
            }
            ClickType click = event.getClick();
            if (click != ClickType.LEFT && click != ClickType.RIGHT && ItemUtils.isInventoryFull(player)) {
                return;
            }
            if (event.getResult() != Event.Result.ALLOW) {
                return;
            }
            if (player.getItemOnCursor().getType() != Material.AIR) {
                return;
            }
            if (event.getClickedInventory().getType() == InventoryType.GRINDSTONE && event.getSlotType() == InventoryType.SlotType.RESULT) {
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                if (playerData.getAbilityLevel(Ability.DISENCHANTER) == 0) {
                    return;
                }
                Location location = inventory.getLocation();
                if (location == null) {
                    return;
                }
                ItemStack first = inventory.getItem(0);
                ItemStack second = inventory.getItem(1);
                if (first != null && second != null && first.getType() != second.getType()) {
                    return;
                }
                HashSet<EnchantmentValue> enchants = new HashSet<EnchantmentValue>();
                this.checkEnchants(first, enchants);
                this.checkEnchants(second, enchants);
                if (enchants.size() == 0) {
                    return;
                }
                try {
                    int sum = 0;
                    for (EnchantmentValue value : enchants) {
                        String enchantName = value.getEnchantment().getKey().getKey().toUpperCase(Locale.ENGLISH);
                        if (!this.containsEnchant(enchantName)) continue;
                        sum += GrindstoneEnchant.valueOf(enchantName).getLevel(value.getLevel());
                    }
                    int average = (sum + (int)Math.ceil((double)sum / 2.0)) / 2;
                    int added = (int)Math.round((double)average * (this.getValue(Ability.DISENCHANTER, playerData) / 100.0));
                    World world = location.getWorld();
                    if (world != null) {
                        ((ExperienceOrb)world.spawn(location, ExperienceOrb.class)).setExperience(added);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private void checkEnchants(ItemStack item, Set<EnchantmentValue> enchants) {
        if (item != null) {
            for (Map.Entry entry : item.getEnchantments().entrySet()) {
                if (((Enchantment)entry.getKey()).equals((Object)Enchantment.BINDING_CURSE) || ((Enchantment)entry.getKey()).equals((Object)Enchantment.VANISHING_CURSE)) continue;
                enchants.add(new EnchantmentValue((Enchantment)entry.getKey(), (Integer)entry.getValue()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void repairing(PrepareAnvilEvent event) {
        if (this.blockDisabled(Ability.REPAIRING)) {
            return;
        }
        Player player = this.getHighestPlayer(event.getViewers());
        if (player == null) {
            return;
        }
        if (this.blockAbility(player)) {
            return;
        }
        AnvilInventory inventory = event.getInventory();
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (playerData.getAbilityLevel(Ability.REPAIRING) == 0) {
            return;
        }
        ItemStack first = inventory.getItem(0);
        ItemStack second = inventory.getItem(1);
        ItemStack result = event.getResult();
        if (first == null || second == null || result == null) {
            return;
        }
        XMaterial rawMaterial = this.getRawMaterial(first.getType());
        if (rawMaterial == null) {
            return;
        }
        if (second.getType() == rawMaterial.parseMaterial()) {
            if (XMaterial.isNewVersion()) {
                ItemMeta meta = first.getItemMeta();
                if (meta == null) {
                    return;
                }
                if (meta instanceof Damageable) {
                    Damageable damageable = (Damageable)meta;
                    short max = first.getType().getMaxDurability();
                    long addedLong = (long)second.getAmount() * (Math.round(0.25 * (double)max) + Math.round((double)max * 0.25 * (this.getValue(Ability.REPAIRING, playerData) / 100.0)));
                    short added = addedLong > 32767L ? (short)damageable.getDamage() : (addedLong < -32768L ? (short)0 : (short)addedLong);
                    damageable.setDamage(Math.max(damageable.getDamage() - added, 0));
                    result.setItemMeta((ItemMeta)damageable);
                }
            } else {
                short max = result.getType().getMaxDurability();
                long addedLong = (long)second.getAmount() * (Math.round(0.25 * (double)max) + Math.round((double)max * 0.25 * (this.getValue(Ability.REPAIRING, playerData) / 100.0)));
                short added = addedLong > 32767L ? first.getDurability() : (addedLong < -32768L ? (short)0 : (short)addedLong);
                result.setDurability((short)Math.max(first.getDurability() - added, 0));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void anvilMaster(InventoryOpenEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.blockDisabled(Ability.ANVIL_MASTER)) {
            return;
        }
        if (!XMaterial.isNewVersion()) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (inventory.getType() == InventoryType.ANVIL && inventory instanceof AnvilInventory) {
            AnvilInventory anvil = (AnvilInventory)inventory;
            if (event.getPlayer() instanceof Player) {
                Player player = (Player)event.getPlayer();
                if (this.blockAbility(player)) {
                    return;
                }
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                if (playerData.getAbilityLevel(Ability.ANVIL_MASTER) > 0) {
                    int maxCost = (int)Math.round(this.getValue(Ability.ANVIL_MASTER, playerData));
                    anvil.setMaximumRepairCost(maxCost);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void skillMender(XpGainEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.blockDisabled(Ability.SKILL_MENDER)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (playerData.getAbilityLevel(Ability.SKILL_MENDER) == 0) {
            return;
        }
        if (this.random.nextDouble() < this.getValue(Ability.SKILL_MENDER, playerData) / 100.0) {
            ItemStack offHandItem;
            ArrayList<ItemStack> mendingItems = new ArrayList<ItemStack>();
            for (ItemStack item : player.getInventory().getArmorContents()) {
                if (item == null || !item.containsEnchantment(Enchantment.MENDING) || !this.hasDamage(item)) continue;
                mendingItems.add(item);
            }
            ItemStack mainHandItem = player.getInventory().getItemInMainHand();
            if (mainHandItem.containsEnchantment(Enchantment.MENDING) && this.hasDamage(mainHandItem)) {
                mendingItems.add(mainHandItem);
            }
            if ((offHandItem = player.getInventory().getItemInOffHand()).containsEnchantment(Enchantment.MENDING) && this.hasDamage(offHandItem)) {
                mendingItems.add(offHandItem);
            }
            if (mendingItems.size() == 0) {
                return;
            }
            ItemStack mendedItem = (ItemStack)mendingItems.get(this.random.nextInt(mendingItems.size()));
            int durabilityToRepair = (int)Math.round(event.getAmount() / 2.0);
            if (XMaterial.isNewVersion()) {
                ItemMeta meta = mendedItem.getItemMeta();
                if (meta == null) {
                    return;
                }
                if (meta instanceof Damageable) {
                    Damageable damageable = (Damageable)meta;
                    damageable.setDamage(Math.max(damageable.getDamage() - durabilityToRepair, 0));
                    mendedItem.setItemMeta((ItemMeta)damageable);
                }
            } else {
                mendedItem.setDurability((short)Math.max(mendedItem.getDurability() - durabilityToRepair, 0));
            }
        }
    }

    @Nullable
    private XMaterial getRawMaterial(Material material) {
        String name = material.name();
        if (name.startsWith("DIAMOND_")) {
            if (!(name.equals("DIAMOND_ORE") || name.equals("DIAMOND_BLOCK") || name.equals("DIAMOND_HORSE_ARMOR"))) {
                return XMaterial.DIAMOND;
            }
        } else if (name.startsWith("GOLD_") || name.startsWith("GOLDEN_")) {
            if (!(name.contains("APPLE") || name.contains("CARROT") || name.contains("HORSE_ARMOR") || name.contains("GOLD") || name.contains("INGOT") || name.contains("NUGGET") || name.contains("ORE") || name.contains("BARDING"))) {
                return XMaterial.GOLD_INGOT;
            }
        } else if (name.startsWith("IRON_")) {
            if (!(name.contains("BARS") || name.contains("DOOR") || name.contains("BLOCK") || name.contains("INGOT") || name.contains("NUGGET") || name.contains("ORE") || name.contains("TRAPDOOR") || name.contains("HORSE_ARMOR"))) {
                return XMaterial.IRON_INGOT;
            }
        } else if (name.startsWith("LEATHER_")) {
            if (!name.contains("HORSE_ARMOR")) {
                return XMaterial.LEATHER;
            }
        } else if (name.startsWith("NETHERITE_")) {
            if (!(name.contains("SCRAP") || name.contains("INGOT") || name.contains("BLOCK"))) {
                return XMaterial.NETHERITE_INGOT;
            }
        } else {
            if (name.equals("TURTLE_HELMET")) {
                return XMaterial.SCUTE;
            }
            if (material == Material.ELYTRA) {
                return XMaterial.PHANTOM_MEMBRANE;
            }
            if (name.startsWith("CHAINMAIL")) {
                return XMaterial.IRON_INGOT;
            }
        }
        return null;
    }

    @Nullable
    private Player getHighestPlayer(List<HumanEntity> viewers) {
        int highestLevel = 0;
        Player highestPlayer = null;
        for (HumanEntity entity : viewers) {
            int level;
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null || (level = playerData.getSkillLevel(Skills.FORGING)) <= highestLevel) continue;
            highestLevel = level;
            highestPlayer = player;
        }
        return highestPlayer;
    }

    private boolean hasDamage(ItemStack item) {
        if (XMaterial.isNewVersion()) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null && meta instanceof Damageable) {
                return ((Damageable)meta).hasDamage();
            }
        } else {
            return item.getDurability() > 0;
        }
        return false;
    }

    private boolean containsEnchant(String enchantName) {
        for (GrindstoneEnchant grindstoneEnchant : GrindstoneEnchant.values()) {
            if (!grindstoneEnchant.toString().equals(enchantName)) continue;
            return true;
        }
        return false;
    }
}

