/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.foraging;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.foraging.ForagingAbilities;
import com.archyx.aureliumskills.skills.foraging.ForagingSource;
import com.archyx.aureliumskills.source.SourceTag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class ForagingLeveler
extends SkillLeveler
implements Listener {
    private final ForagingAbilities foragingAbilities;

    public ForagingLeveler(AureliumSkills plugin) {
        super(plugin, Ability.FORAGER);
        this.foragingAbilities = new ForagingAbilities(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!OptionL.isEnabled(Skills.FORAGING)) {
            return;
        }
        if (OptionL.getBoolean(Option.FORAGING_CHECK_CANCELLED) && event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockXpGainLocation(event.getBlock().getLocation(), player)) {
            return;
        }
        if (this.blockXpGainPlayer(player)) {
            return;
        }
        for (ForagingSource source : ForagingSource.values()) {
            if (!source.isMatch(block)) continue;
            this.plugin.getLeveler().addXp(player, Skills.FORAGING, this.getXp(player, source));
            if (!this.hasTag(source, SourceTag.LUMBERJACK_APPLICABLE) || !event.isDropItems()) break;
            this.foragingAbilities.lumberjack(player, block);
            break;
        }
        this.checkCustomBlocks(player, block, Skills.FORAGING);
    }
}

